/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionSpec;
import org.simplejavamail.api.internal.clisupport.model.CliReceivedCommand;
import org.simplejavamail.api.mailer.MailerFromSessionBuilder;
import org.simplejavamail.api.mailer.MailerRegularBuilder;
import org.simplejavamail.internal.clisupport.BuilderApiToPicocliCommandsMapper;
import org.simplejavamail.internal.clisupport.CliCommandLineConsumer;
import org.simplejavamail.internal.clisupport.CliCommandLineConsumerResultHandler;
import org.simplejavamail.internal.clisupport.CliCommandLineConsumerUsageHelper;
import org.simplejavamail.internal.clisupport.CliCommandLineProducer;
import org.simplejavamail.internal.clisupport.CliDataLocator;
import org.simplejavamail.internal.clisupport.CliExecutionException;
import org.simplejavamail.internal.clisupport.serialization.SerializationUtil;
import org.simplejavamail.internal.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CliSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliSupport.class);
    private static final int CONSOLE_TEXT_WIDTH = 150;
    private static final File CLI_DATAFILE = new File(CliDataLocator.locateCLIDataFile());
    private static final Class<?>[] RELEVANT_BUILDER_ROOT_API = new Class[]{EmailStartingBuilder.class, MailerRegularBuilder.class, MailerFromSessionBuilder.class};
    private static final List<CliDeclaredOptionSpec> DECLARED_OPTIONS = CliSupport.produceCliDeclaredOptionSpec();
    private static final CommandLine PICOCLI_COMMAND_LINE = CliCommandLineProducer.configurePicoCli(DECLARED_OPTIONS, 150);

    private static List<CliDeclaredOptionSpec> produceCliDeclaredOptionSpec() {
        try {
            if (!CLI_DATAFILE.exists()) {
                LOGGER.info("Initial cli.data not found, writing to (one time action): {}", (Object)CLI_DATAFILE);
                List<CliDeclaredOptionSpec> declaredOptions = BuilderApiToPicocliCommandsMapper.generateOptionsFromBuilderApi(RELEVANT_BUILDER_ROOT_API);
                FileUtil.writeFileBytes((File)CLI_DATAFILE, (byte[])SerializationUtil.serialize(declaredOptions));
            }
            return (List)SerializationUtil.deserialize(FileUtil.readFileBytes((File)CLI_DATAFILE));
        }
        catch (IOException e) {
            throw new CliExecutionException("Got error while invoking Builder API with argument(s) '%s' for '%s'", e);
        }
    }

    public static void runCLI(String[] args) {
        CommandLine.ParseResult pr = PICOCLI_COMMAND_LINE.parseArgs(CliSupport.cutOffAtHelp(args));
        if (!CliCommandLineConsumerUsageHelper.processAndApplyHelp(pr, 150)) {
            CliReceivedCommand cliReceivedOptionData = CliCommandLineConsumer.consumeCommandLineInput(pr, DECLARED_OPTIONS);
            CliCommandLineConsumerResultHandler.processCliResult(cliReceivedOptionData);
        }
    }

    public static void listUsagesForAllOptions() {
        for (CliDeclaredOptionSpec declaredOption : DECLARED_OPTIONS) {
            CliSupport.runCLI(new String[]{"send", declaredOption.getName() + "--help"});
            System.out.print("\n\n\n");
        }
    }

    private static String[] cutOffAtHelp(String[] args) {
        ArrayList<String> argsToKeep = new ArrayList<String>();
        for (String arg : args) {
            argsToKeep.add(arg);
            if (arg.endsWith("--help")) break;
        }
        if (argsToKeep.isEmpty()) {
            argsToKeep.add("--help");
        }
        return argsToKeep.toArray(new String[0]);
    }
}

