/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.therapijavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.InlineTag;
import com.github.therapi.runtimejavadoc.InlineValue;
import org.simplejavamail.internal.clisupport.therapijavadoc.SimpleHTMLEscapeUtil;

public abstract class CommentFormatter {
    public String format(Comment comment) {
        if (comment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CommentElement e : comment) {
            if (e instanceof CommentText) {
                sb.append(this.renderText((CommentText)e));
                continue;
            }
            if (e instanceof InlineLink) {
                sb.append(this.renderLink((InlineLink)e));
                continue;
            }
            if (e instanceof InlineValue) {
                sb.append(this.renderValue((InlineValue)e));
                continue;
            }
            if (e instanceof InlineTag) {
                if (((InlineTag)e).getName().equals("code")) {
                    sb.append(this.renderCode((InlineTag)e));
                    continue;
                }
                if (((InlineTag)e).getName().equals("literal")) {
                    sb.append(SimpleHTMLEscapeUtil.escapeHTML(((InlineTag)e).getValue()));
                    continue;
                }
                sb.append(this.renderUnrecognizedTag((InlineTag)e));
                continue;
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    protected abstract String renderText(CommentText var1);

    protected abstract String renderLink(InlineLink var1);

    protected abstract String renderValue(InlineValue var1);

    protected abstract String renderCode(InlineTag var1);

    protected abstract String renderUnrecognizedTag(InlineTag var1);
}

