/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.therapijavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.InlineTag;
import com.github.therapi.runtimejavadoc.InlineValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionValue;
import org.simplejavamail.internal.clisupport.BuilderApiToPicocliCommandsMapper;
import org.simplejavamail.internal.clisupport.therapijavadoc.ContextualCommentFormatter;
import org.simplejavamail.internal.clisupport.therapijavadoc.TherapiJavadocHelper;
import org.simplejavamail.internal.util.Preconditions;

public class JavadocForCliFormatter
extends ContextualCommentFormatter {
    private final List<String> includedReferredDocumentation = new ArrayList<String>();

    JavadocForCliFormatter() {
        super(0);
    }

    JavadocForCliFormatter(int nestingDepth) {
        super(nestingDepth);
    }

    @Override
    @NotNull
    public String format(Comment comment) {
        Pattern PATTERN_JAVADOC_TAG = Pattern.compile("\\{@\\w+");
        Pattern PATTERN_HTML_TAG = Pattern.compile("</?[A-Za-z]+>");
        Pattern PATTERN_TODO_FIXME = Pattern.compile("//\\s*?(?:TODO|FIXME)");
        String result = this.indent() + this.removeStructuralHTML(super.format(comment));
        Preconditions.assumeTrue((!PATTERN_JAVADOC_TAG.matcher(result).find() && !PATTERN_HTML_TAG.matcher(result).find() && !PATTERN_TODO_FIXME.matcher(result).find() ? 1 : 0) != 0, (String)("Output not properly formatted for CLI usage: \n\t" + result + "\n\t-----------"));
        StringBuilder completeResult = new StringBuilder(result);
        for (String includedDocumentation : this.includedReferredDocumentation) {
            completeResult.append("\n\n").append(this.indent(1)).append(includedDocumentation);
        }
        return completeResult.toString();
    }

    @Override
    protected String renderText(CommentText text) {
        return text.getValue().replaceAll("\\s*\\n\\s*", " ").replaceAll("\\s*<br\\s*/?>\\s*", "\n" + this.indent()).replaceAll("\\s*</?p\\s*>\\s*", "\n\n" + this.indent()).replaceAll("<strong>(.*?)</strong>", "@|bold $1|@").replaceAll("<em>(.*?)</em>", "@|italic $1|@").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("\\{@code (.*?)}", JavadocForCliFormatter.formatCode("$1")).replaceAll("<code>(.*?)</code>", JavadocForCliFormatter.formatCode("$1")).replaceAll("<a href=\"(.+?)\">(.+?)</a>", "$2 ($1)").replaceAll("%s", "%%s");
    }

    @Override
    protected String renderCode(InlineTag e) {
        return JavadocForCliFormatter.formatCode(e.getValue().replaceAll("%s", "%%s"));
    }

    @NotNull
    private static String formatCode(String value) {
        return String.format("@|%s %s|@", "green", value);
    }

    @Override
    protected String renderLink(InlineLink link) {
        return this.renderLink(link, true);
    }

    String renderLink(InlineLink link, boolean includeReferredDocumentation) {
        Method m = TherapiJavadocHelper.findMethodForLink(link.getLink());
        if (m != null) {
            String result;
            Class<?> apiNode = m.getDeclaringClass();
            boolean isCliCompatible = BuilderApiToPicocliCommandsMapper.methodIsCliCompatible(m).isCompatible();
            String string = result = isCliCompatible ? String.format("@|%s %s|@", "cyan", BuilderApiToPicocliCommandsMapper.determineCliOptionName(apiNode, m)) : this.formatMethodReference("java-only method @|italic,faint ", m, "|@");
            if (includeReferredDocumentation) {
                result = result + (this.checkIncludeReferredDocumentation(link, m, isCliCompatible) ? " (see below)" : "");
            }
            return result;
        }
        return String.format("@|%s %s|@", "green", link.getLink().getLabel().replace('#', '.').replaceAll("^\\.(.*)", "$1").trim());
    }

    private boolean checkIncludeReferredDocumentation(InlineLink e, Method methodDelegate, boolean methodDelegateIsCliCompatible) {
        if (this.previousElementImpliesLinkedJavadocShouldBeIncluded((CommentElement)e)) {
            Class<?> apiNode = methodDelegate.getDeclaringClass();
            String inclusionHeader = methodDelegateIsCliCompatible ? String.format("@|bold -> %s %s|@:%n", BuilderApiToPicocliCommandsMapper.determineCliOptionName(apiNode, methodDelegate), this.formatCliOptionValues(BuilderApiToPicocliCommandsMapper.getArgumentsForCliOption(methodDelegate))) : this.formatMethodReference("@|bold -> ", methodDelegate, "|@:%n");
            this.includedReferredDocumentation.add(inclusionHeader + TherapiJavadocHelper.getJavadocMainDescription(methodDelegate, this.currentNestingDepth + 1));
            return true;
        }
        return false;
    }

    private String formatCliOptionValues(List<CliDeclaredOptionValue> argumentsForCliOption) {
        StringBuilder result = new StringBuilder();
        for (CliDeclaredOptionValue v : argumentsForCliOption) {
            result.append(v.getName()).append("(=").append(v.getHelpLabel()).append(") ");
        }
        return result.toString().trim();
    }

    @NotNull
    private String formatMethodReference(@NotNull String prefix, @NotNull Method m, @NotNull String postfix) {
        return String.format("%s%s(%s)%s", prefix, m.getName(), JavadocForCliFormatter.describeMethodParameterTypes(m), postfix);
    }

    @NotNull
    private static String describeMethodParameterTypes(Method deferredMethod) {
        StringBuilder result = new StringBuilder();
        for (Class<?> parameterType : deferredMethod.getParameterTypes()) {
            result.append(result.length() == 0 ? "" : ", ").append(parameterType.getSimpleName());
        }
        return result.toString();
    }

    private boolean previousElementImpliesLinkedJavadocShouldBeIncluded(CommentElement e) {
        CommentElement previousElement = this.getPreviousElement(e);
        if (previousElement instanceof InlineLink) {
            return this.previousElementImpliesLinkedJavadocShouldBeIncluded(previousElement);
        }
        if (previousElement instanceof CommentText) {
            String trimmedToPlainText;
            Pattern WORD_PATTERN = Pattern.compile("\\w");
            Pattern PATTERN_ALIAS_FOR = Pattern.compile("(?i)Alias for:?");
            Pattern PATTERN_DELEGATES_TO = Pattern.compile("(?i)(?:delegates|delegating) to:?");
            return PATTERN_DELEGATES_TO.matcher(trimmedToPlainText = this.removeStructuralHTML(((CommentText)previousElement).getValue()).trim()).find() || PATTERN_ALIAS_FOR.matcher(trimmedToPlainText).find() || !WORD_PATTERN.matcher(trimmedToPlainText).find() && this.previousElementImpliesLinkedJavadocShouldBeIncluded(previousElement);
        }
        return false;
    }

    @Override
    @NotNull
    protected String renderValue(InlineValue e) {
        Object obj = TherapiJavadocHelper.resolveFieldForValue(e.getValue());
        if (obj != null) {
            return String.format("@|%s %s|@", "green", obj);
        }
        throw new AssertionError((Object)"{@value} cannot be resolved");
    }

    @Override
    protected String renderUnrecognizedTag(InlineTag e) {
        throw new AssertionError((Object)String.format("Found unsupported tag: %s=%s", e.getName(), e.getValue()));
    }

    @NotNull
    private String removeStructuralHTML(@NotNull String textWithHtml) {
        return textWithHtml.replaceAll("<li>", "\n  - " + this.indent()).replaceAll("</li>", "").replaceAll("</?[ou]l>", "");
    }
}

