/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.therapijavadoc;

import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.Value;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bbottema.javareflection.ClassUtils;
import org.bbottema.javareflection.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.clisupport.BuilderApiToPicocliCommandsMapper;
import org.simplejavamail.internal.clisupport.CliDataLocator;
import org.simplejavamail.internal.clisupport.serialization.SerializationUtil;
import org.simplejavamail.internal.clisupport.therapijavadoc.JavadocForCliFormatter;
import org.simplejavamail.internal.util.FileUtil;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.StringUtil;

public final class TherapiJavadocHelper {
    private static final File THERAPI_DATAFILE = new File(CliDataLocator.locateTherapiDataFile());
    private static final Map<String, MethodJavadoc> THERAPI_CACHE = TherapiJavadocHelper.loadTherapiCache();

    private static Map<String, MethodJavadoc> loadTherapiCache() {
        if (THERAPI_DATAFILE.exists()) {
            try {
                return (Map)SerializationUtil.deserialize(FileUtil.readFileBytes((File)THERAPI_DATAFILE));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new HashMap<String, MethodJavadoc>();
    }

    public static void persistCache() {
        try {
            FileUtil.writeFileBytes((File)THERAPI_DATAFILE, (byte[])SerializationUtil.serialize(THERAPI_CACHE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TherapiJavadocHelper() {
    }

    @Nullable
    static Method findMethodForLink(Link link) {
        Class<?> aClass;
        if (link.getReferencedMemberName() != null && (aClass = TherapiJavadocHelper.findReferencedClass(link.getReferencedClassName())) != null) {
            Set matchingMethods = MethodUtils.findMatchingMethods(aClass, aClass, (String)link.getReferencedMemberName(), (List)link.getParams());
            return matchingMethods.isEmpty() ? null : (Method)matchingMethods.iterator().next();
        }
        return null;
    }

    @Nullable
    static Object resolveFieldForValue(Value value) {
        Class<?> aClass = TherapiJavadocHelper.findReferencedClass(value.getReferencedClassName());
        if (aClass != null) {
            return ClassUtils.solveFieldValue(aClass, (String)value.getReferencedMemberName());
        }
        return null;
    }

    @Nullable
    private static Class<?> findReferencedClass(String referencedClassName) {
        return Optional.ofNullable(ClassUtils.locateClass((String)referencedClassName, (String)"org.simplejavamail", null)).orElseGet(() -> ClassUtils.locateClass((String)referencedClassName, null, null));
    }

    @NotNull
    static String getJavadocMainDescription(Method m, int nestingDepth) {
        return new JavadocForCliFormatter(nestingDepth).format(TherapiJavadocHelper.getMethodJavadocCached(m).getComment());
    }

    @NotNull
    public static List<DocumentedMethodParam> getParamDescriptions(Method m) {
        List params = TherapiJavadocHelper.getMethodJavadocCached(m).getParams();
        if (m.getParameterTypes().length != params.size()) {
            throw new AssertionError((Object)("Number of documented parameters doesn't match with Method's actual parameters: " + m));
        }
        ArrayList<DocumentedMethodParam> paramDescriptions = new ArrayList<DocumentedMethodParam>();
        for (ParamJavadoc param : params) {
            paramDescriptions.add(new DocumentedMethodParam(param.getName(), new JavadocForCliFormatter().format(param.getComment())));
        }
        return paramDescriptions;
    }

    @NotNull
    public static List<String> getJavadocSeeAlsoReferences(Method m, boolean onlyIncludeClicompatibleJavadocLinks, int maxTextWidth) {
        ArrayList<String> seeAlsoReferences = new ArrayList<String>();
        JavadocForCliFormatter cliFormatter = new JavadocForCliFormatter();
        int longestLink = 0;
        boolean allDescriptionsOnNextLine = false;
        for (SeeAlsoJavadoc seeAlsoJavadoc : TherapiJavadocHelper.getMethodJavadocCached(m).getSeeAlso()) {
            switch (seeAlsoJavadoc.getSeeAlsoType()) {
                case STRING_LITERAL: {
                    seeAlsoReferences.add(seeAlsoJavadoc.getStringLiteral());
                    break;
                }
                case HTML_LINK: {
                    SeeAlsoJavadoc.HtmlLink htmlLink = seeAlsoJavadoc.getHtmlLink();
                    seeAlsoReferences.add(String.format("%s (%s)", htmlLink.getText(), htmlLink.getLink()));
                    break;
                }
                case JAVADOC_LINK: {
                    String renderedLink = cliFormatter.renderLink(new InlineLink(seeAlsoJavadoc.getLink()), false);
                    if (onlyIncludeClicompatibleJavadocLinks && !renderedLink.contains("--")) break;
                    Method linkedMethod = TherapiJavadocHelper.findMethodForLink(seeAlsoJavadoc.getLink());
                    if (linkedMethod != null) {
                        List<String> fullDescription = TherapiJavadocHelper.determineCliOptionDescriptions(linkedMethod);
                        String moreInfix = fullDescription.size() > 1 ? " (...more)" : "";
                        String fullSeeAlsoLine = String.format("[[%s]] - %s %s", renderedLink, ListUtil.getFirst(fullDescription), moreInfix);
                        seeAlsoReferences.add(fullSeeAlsoLine);
                        allDescriptionsOnNextLine |= fullSeeAlsoLine.length() > maxTextWidth;
                        longestLink = Math.max(longestLink, renderedLink.length());
                        break;
                    }
                    seeAlsoReferences.add(renderedLink);
                }
            }
        }
        if (longestLink > 0) {
            for (int i = 0; i < seeAlsoReferences.size(); ++i) {
                Matcher matcher = Pattern.compile("\\[\\[(?<link>.+?)]](?<description>.*)").matcher((CharSequence)seeAlsoReferences.get(i));
                if (!matcher.find()) continue;
                String newlineFixer = seeAlsoReferences.size() > 1 && allDescriptionsOnNextLine ? "\n\t" : "";
                String paddedReplacement = StringUtil.padRight((String)matcher.group("link"), (int)longestLink) + newlineFixer + matcher.group("description");
                seeAlsoReferences.set(i, matcher.replaceFirst(paddedReplacement));
            }
        }
        return seeAlsoReferences;
    }

    @NotNull
    private static MethodJavadoc getMethodJavadocCached(Method m) {
        return THERAPI_CACHE.computeIfAbsent(m.toString(), methodKey -> RuntimeJavadoc.getJavadoc((Method)m));
    }

    @NotNull
    public static List<String> determineCliOptionDescriptions(Method m) {
        String javadoc = TherapiJavadocHelper.getJavadocMainDescription(m, 0);
        List<String> basicExplanationPlusFurtherDetails = Arrays.asList(javadoc.split("\n", 2));
        return BuilderApiToPicocliCommandsMapper.colorizeDescriptions(basicExplanationPlusFurtherDetails);
    }

    public static class DocumentedMethodParam {
        @NotNull
        private final String name;
        @NotNull
        private final String javadoc;

        DocumentedMethodParam(@NotNull String name, @NotNull String javadoc) {
            this.name = name;
            this.javadoc = javadoc;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getJavadoc() {
            return this.javadoc;
        }
    }
}

