/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.valueinterpreters;

import java.io.File;
import org.bbottema.javareflection.ReflectionUtils;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.MailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileBasedFunction<T>
implements ValueFunction<String, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedFunction.class);

    FileBasedFunction() {
    }

    public final T convertValue(String value) {
        try {
            return this.convertFile(this.getAsFile(value));
        }
        catch (MailException e) {
            Class toType = ReflectionUtils.findParameterType(this.getClass(), FileBasedFunction.class, (int)0);
            throw new IncompatibleTypeException((Object)value, String.class, toType, (Throwable)e);
        }
    }

    private File getAsFile(String value) {
        File file = new File(value);
        if (!file.exists()) {
            LOGGER.debug("file not found for [" + value + "]");
        }
        return file;
    }

    @NotNull
    protected abstract T convertFile(File var1);
}

