/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.valueinterpreters;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.clisupport.valueinterpreters.FileBasedFunction;
import org.simplejavamail.internal.util.CertificationUtil;

public class PemFilePathToX509CertificateFunction
extends FileBasedFunction<X509Certificate> {
    public Class<String> getFromType() {
        return String.class;
    }

    public Class<X509Certificate> getTargetType() {
        return X509Certificate.class;
    }

    @Override
    @NotNull
    protected X509Certificate convertFile(File msgFile) {
        try {
            return CertificationUtil.readFromPem((File)msgFile);
        }
        catch (FileNotFoundException | NoSuchProviderException | CertificateException e) {
            throw new IncompatibleTypeException((Object)msgFile, String.class, X509Certificate.class, (Throwable)e);
        }
    }
}

