/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.internal.clisupport.model.CliReceivedCommand;
import org.simplejavamail.api.internal.clisupport.model.CliReceivedOptionData;
import org.simplejavamail.api.mailer.MailerGenericBuilder;
import org.simplejavamail.email.internal.EmailStartingBuilderImpl;
import org.simplejavamail.internal.clisupport.CliExecutionException;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CliCommandLineConsumerResultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliCommandLineConsumerResultHandler.class);

    CliCommandLineConsumerResultHandler() {
    }

    static void processCliResult(CliReceivedCommand cliReceivedCommand) {
        LOGGER.debug("invoking Builder API in order of provided options...");
        List receivedOptions = cliReceivedCommand.getReceivedOptions();
        switch (cliReceivedCommand.getMatchedCommand()) {
            case send: {
                CliCommandLineConsumerResultHandler.processCliSend(receivedOptions);
                break;
            }
            case validate: {
                CliCommandLineConsumerResultHandler.processCliValidate(receivedOptions);
                break;
            }
            case connect: {
                CliCommandLineConsumerResultHandler.processCliTestConnection(receivedOptions);
            }
        }
    }

    private static void processCliSend(List<CliReceivedOptionData> receivedOptions) {
        EmailPopulatingBuilder emailBuilder = (EmailPopulatingBuilder)CliCommandLineConsumerResultHandler.invokeBuilderApi(receivedOptions, CliBuilderApiType.EMAIL, new EmailStartingBuilderImpl());
        MailerGenericBuilder mailerBuilder = (MailerGenericBuilder)CliCommandLineConsumerResultHandler.invokeBuilderApi(receivedOptions, CliBuilderApiType.MAILER, new MailerRegularBuilderImpl());
        mailerBuilder.buildMailer().sendMail(emailBuilder.buildEmail());
    }

    private static void processCliTestConnection(List<CliReceivedOptionData> receivedOptions) {
        MailerGenericBuilder mailerBuilder = (MailerGenericBuilder)CliCommandLineConsumerResultHandler.invokeBuilderApi(receivedOptions, CliBuilderApiType.MAILER, new MailerRegularBuilderImpl());
        mailerBuilder.buildMailer().testConnection();
    }

    private static void processCliValidate(List<CliReceivedOptionData> receivedOptions) {
        EmailPopulatingBuilder emailBuilder = (EmailPopulatingBuilder)CliCommandLineConsumerResultHandler.invokeBuilderApi(receivedOptions, CliBuilderApiType.EMAIL, new EmailStartingBuilderImpl());
        MailerGenericBuilder mailerBuilder = (MailerGenericBuilder)CliCommandLineConsumerResultHandler.invokeBuilderApi(receivedOptions, CliBuilderApiType.MAILER, new MailerRegularBuilderImpl());
        mailerBuilder.buildMailer().validate(emailBuilder.buildEmailCompletedWithDefaultsAndOverrides());
    }

    private static <T> T invokeBuilderApi(List<CliReceivedOptionData> cliReceivedOptionData, CliBuilderApiType builderApiType, Object initialBuilderInstance) {
        LOGGER.debug("\t{}", (Object)initialBuilderInstance.getClass().getSimpleName());
        Object currentBuilder = initialBuilderInstance;
        for (CliReceivedOptionData option : cliReceivedOptionData) {
            if (option.determineTargetBuilderApi() != builderApiType) continue;
            try {
                LOGGER.debug("\t\t.{}({})", (Object)option.getDeclaredOptionSpec().getSourceMethod().getName(), (Object)option.getProvidedOptionValues());
                Method sourceMethod = CliCommandLineConsumerResultHandler.determineTrueSourceMethod(option.getDeclaredOptionSpec().getSourceMethod());
                currentBuilder = sourceMethod.invoke(currentBuilder, option.getProvidedOptionValues().toArray());
            }
            catch (IllegalArgumentException e) {
                throw new CliExecutionException(CliCommandLineConsumerResultHandler.formatCliInvocationError("Wrong argument(s) '%s' for '%s'.\nAlso, make sure you start with one of the following options:\n\t\t--email:startingBlank\n\t\t--email:copying message(=FILE)\n\t\t--email:forwarding message(=FILE)\n\t\t--email:replyingTo emailMessage(=FILE) repyToAll(=BOOL) htmlTemplate(=TEXT)\n\t\t--email:replyingToSender message(=FILE) customQuotingTemplate(=TEXT)\n\t\t--email:replyingToSenderWithDefaultQuoteMarkup message(=FILE)\n\t\t--email:replyingToAll message(=FILE) customQuotingTemplate(=TEXT)\n\t\t--email:replyingToAllWithDefaultQuoteMarkup message(=FILE)", option), e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new CliExecutionException(CliCommandLineConsumerResultHandler.formatCliInvocationError("Got error while invoking Builder API with argument(s) '%s' for '%s'", option), e);
            }
            catch (NoSuchMethodException e) {
                throw new CliExecutionException("This should never happen", e);
            }
        }
        return (T)currentBuilder;
    }

    @NotNull
    private static Method determineTrueSourceMethod(@NotNull Method sourceMethod) throws NoSuchMethodException {
        return sourceMethod.getDeclaringClass().getDeclaredMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
    }

    private static String formatCliInvocationError(String exceptionTemplate, CliReceivedOptionData option) {
        return String.format(exceptionTemplate, option.getProvidedOptionValues(), option.getDeclaredOptionSpec().getName());
    }
}

