/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionSpec;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionValue;
import org.simplejavamail.internal.clisupport.BuilderApiToPicocliCommandsMapper;
import org.simplejavamail.internal.clisupport.therapijavadoc.TherapiJavadocHelper;
import org.simplejavamail.internal.util.ListUtil;
import picocli.CommandLine;

class CliCommandLineProducer {
    static final String OPTION_HELP_POSTFIX = "--help";
    static final String EMPTY_PARAM_LABEL = "<empty>";

    CliCommandLineProducer() {
    }

    static CommandLine configurePicoCli(List<CliDeclaredOptionSpec> declaredOptions, int maxTextWidth) {
        CommandLine.Model.CommandSpec rootCommandsHolder = CliCommandLineProducer.createDefaultCommandSpec("SimpleJavaMail", "Simple Java Mail Command Line Interface.%n%nAll commands and their options are a direct translation of the Simple Java Mail builder API and translate back into builder calls (as such, the order of --options matter as well as combinations). Furthermore, all documentation is taken from the builder API Javadoc. Essentially you configure builders just like you would in Java, but with CLI commands.%n%n@|bold Note that each and every |@@|yellow,bold --option|@ @|bold has an |@@|yellow,bold --option--help|@ @|bold variation for full documentation.|@%nNote: All the regular functionality regarding properties and config files work with the CLI so you can provide defaults in a property file as long as it is visible (on class path) or as system environment variables.").version(new String[]{"Simple Java Mail 8.6.3"});
        rootCommandsHolder.usageMessage().customSynopsis(new String[]{"", BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tsend     [--help -h, --version -v] --email:options --mailer:options", "yellow"), BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tconnect  [--help -h, --version -v] --mailer:options", "yellow"), BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tvalidate [--help -h, --version -v] --email:options", "yellow")});
        CliCommandLineProducer.createRootCommand(rootCommandsHolder, "send", "Send an email: starting blank, replying to or forwarding another email.", BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tsend [--help -h, --version -v] --email:options --mailer:options", "yellow"), declaredOptions, maxTextWidth);
        CliCommandLineProducer.createRootCommand(rootCommandsHolder, "connect", "Test a server connection, including possible authentication and any proxy settings", BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tconnect [--help -h, --version -v] --mailer:options", "yellow"), declaredOptions, maxTextWidth);
        CliCommandLineProducer.createRootCommand(rootCommandsHolder, "validate", "Validate an email for mandatory fields, injection detection and optional email address validation", BuilderApiToPicocliCommandsMapper.colorizeOptionsInText("\tvalidate [--help -h, --version -v] --email:options --mailer:options", "yellow"), declaredOptions, maxTextWidth);
        return new CommandLine((Object)rootCommandsHolder).setUsageHelpWidth(maxTextWidth).setSeparator(" ");
    }

    private static void createRootCommand(CommandLine.Model.CommandSpec rootCommandsHolder, String name, String description, String synopsis, List<CliDeclaredOptionSpec> declaredOptions, int maxTextWidth) {
        CommandLine.Model.CommandSpec rootCommand = CliCommandLineProducer.createDefaultCommandSpec(name, description);
        Collection compatibleBuilderApiTypes = CliBuilderApiType.findForCliSynopsis((String)synopsis);
        rootCommand.usageMessage().customSynopsis(new String[]{synopsis});
        CliCommandLineProducer.populateRootCommands(rootCommand, declaredOptions, compatibleBuilderApiTypes, maxTextWidth);
        rootCommandsHolder.addSubcommand(rootCommand.name(), rootCommand);
    }

    private static void populateRootCommands(CommandLine.Model.CommandSpec rootCommand, List<CliDeclaredOptionSpec> declaredOptions, Collection<CliBuilderApiType> compatibleBuilderApiTypes, int maxTextWidth) {
        for (CliDeclaredOptionSpec cliDeclaredOptionSpec : declaredOptions) {
            if (!cliDeclaredOptionSpec.applicableToRootCommand(compatibleBuilderApiTypes)) continue;
            rootCommand.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)cliDeclaredOptionSpec.getName(), (String[])new String[0]).type(List.class)).auxiliaryTypes(new Class[]{String.class})).arity(String.format("%s..%s", cliDeclaredOptionSpec.getMandatoryOptionValues().size(), cliDeclaredOptionSpec.getPossibleOptionValues().size()))).paramLabel(CliCommandLineProducer.determineParamLabel(cliDeclaredOptionSpec.getPossibleOptionValues()))).hideParamSyntax(true)).description(CliCommandLineProducer.determineDescription(cliDeclaredOptionSpec, false, maxTextWidth))).build());
            rootCommand.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)(cliDeclaredOptionSpec.getName() + OPTION_HELP_POSTFIX), (String[])new String[0]).type(List.class)).auxiliaryTypes(new Class[]{String.class})).arity("*")).hidden(true)).help(true).paramLabel(CliCommandLineProducer.determineParamLabel(cliDeclaredOptionSpec.getPossibleOptionValues()))).hideParamSyntax(true)).description(CliCommandLineProducer.determineDescription(cliDeclaredOptionSpec, true, maxTextWidth))).build());
        }
    }

    private static String[] determineDescription(CliDeclaredOptionSpec cliCommand, boolean fullDescription, int maxTextWidth) {
        List<String> descriptions = CliCommandLineProducer.formatOptionDescription(cliCommand, maxTextWidth);
        if (!fullDescription && descriptions.size() > 1) {
            return new String[]{(String)ListUtil.getFirst(descriptions) + " (...more)"};
        }
        return descriptions.toArray(new String[0]);
    }

    @NotNull
    private static List<String> formatOptionDescription(CliDeclaredOptionSpec cliOption, int maxTextWidth) {
        List<String> seeAlsoReferences;
        ArrayList<String> fullDescription = new ArrayList<String>(cliOption.getDescription());
        if (!cliOption.getPossibleOptionValues().isEmpty()) {
            fullDescription.add("%n@|bold,underline Parameters|@:");
            for (CliDeclaredOptionValue possibleValue : cliOption.getPossibleOptionValues()) {
                String optionalInfix = !possibleValue.isRequired() ? " (optional->null)" : "";
                fullDescription.add(String.format("@|%s %s%s|@: %s", "yellow", possibleValue.getName(), optionalInfix, possibleValue.formatDescription()));
            }
        }
        if (!(seeAlsoReferences = TherapiJavadocHelper.getJavadocSeeAlsoReferences(cliOption.getSourceMethod(), true, maxTextWidth)).isEmpty()) {
            fullDescription.add("%n@|bold,underline See also|@:");
            fullDescription.addAll(seeAlsoReferences);
        }
        return fullDescription;
    }

    private static String determineParamLabel(List<CliDeclaredOptionValue> possibleParams) {
        StringBuilder paramLabel = new StringBuilder();
        for (CliDeclaredOptionValue possibleParam : possibleParams) {
            paramLabel.append(possibleParam.isRequired() ? "" : "[");
            paramLabel.append(possibleParam.getName()).append("(=").append(possibleParam.getHelpLabel()).append(")");
            paramLabel.append(possibleParam.isRequired() ? " " : "] ");
        }
        String declaredParamLabel = paramLabel.toString().trim();
        return declaredParamLabel.isEmpty() ? EMPTY_PARAM_LABEL : declaredParamLabel;
    }

    private static CommandLine.Model.CommandSpec createDefaultCommandSpec(@NotNull String name, String ... descriptions) {
        CommandLine.Model.CommandSpec command = CommandLine.Model.CommandSpec.create().name(name).mixinStandardHelpOptions(true);
        command.usageMessage().description(descriptions).headerHeading("%n@|bold,underline Usage|@:").commandListHeading("%n@|bold,underline Commands|@:%n").synopsisHeading(" ").descriptionHeading("%n@|bold,underline Description|@:%n").optionListHeading("%n@|bold,underline Options|@:%n").parameterListHeading("%n@|bold,underline Parameters|@:%n").footerHeading("%n").footer(new String[]{"@|faint,italic https://www.simplejavamail.org/#/cli|@"});
        return command;
    }
}

