/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.clisupport.therapijavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.clisupport.therapijavadoc.CommentFormatter;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.StringUtil;

abstract class ContextualCommentFormatter
extends CommentFormatter {
    final int currentNestingDepth;
    private Comment currentComment;

    ContextualCommentFormatter(int currentNestingDepth) {
        this.currentNestingDepth = currentNestingDepth;
    }

    @Override
    public String format(Comment comment) {
        this.currentComment = comment;
        return super.format(comment);
    }

    @NotNull
    String indent() {
        return this.indent(0);
    }

    @NotNull
    String indent(int depthModifier) {
        return StringUtil.nStrings((int)(this.currentNestingDepth + depthModifier), (String)"  ");
    }

    @Nullable
    CommentElement getPreviousElement(CommentElement e) {
        List elements = this.currentComment.getElements();
        int currentElementIndex = elements.indexOf(e);
        Preconditions.assumeTrue((currentElementIndex >= 0 ? 1 : 0) != 0, (String)"CommentElement instance not found in Comment structure.");
        return currentElementIndex == 0 ? null : (CommentElement)this.currentComment.getElements().get(currentElementIndex - 1);
    }
}

