/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.email.config.DkimConfig;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.SimpleConversions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    public static final String DEFAULT_CONFIG_FILENAME = "simplejavamail.properties";
    private static final Pattern EXTRA_PROPERTY_PATTERN = Pattern.compile("^simplejavamail\\.extraproperties\\.(?<actualProperty>.*)");
    private static final Map<Property, Object> RESOLVED_PROPERTIES = new HashMap<Property, Object>();

    private ConfigLoader() {
    }

    @Nullable
    public static <T> T valueOrProperty(@Nullable T value, Property property) {
        return ConfigLoader.valueOrProperty(value, property, null);
    }

    @Nullable
    public static String valueOrPropertyAsString(@Nullable String value, @NotNull Property property, @Nullable String defaultValue) {
        return SimpleConversions.convertToString(ConfigLoader.valueOrProperty(value, property, defaultValue));
    }

    @Nullable
    public static Boolean valueOrPropertyAsBoolean(@Nullable Boolean value, @NotNull Property property, @Nullable Boolean defaultValue) {
        return SimpleConversions.convertToBoolean(ConfigLoader.valueOrProperty(value, property, defaultValue));
    }

    @Nullable
    public static Integer valueOrPropertyAsInteger(@Nullable Integer value, @NotNull Property property, @Nullable Integer defaultValue) {
        return SimpleConversions.convertToInteger(ConfigLoader.valueOrProperty(value, property, defaultValue));
    }

    @Nullable
    public static <T> T valueOrProperty(@Nullable T value, @NotNull Property property, @Nullable T defaultValue) {
        if (!MiscUtil.valueNullOrEmpty(value)) {
            LOGGER.trace("using provided argument value {} for property {}", value, (Object)property);
            return value;
        }
        if (ConfigLoader.hasProperty(property)) {
            T propertyValue = ConfigLoader.getProperty(property);
            LOGGER.trace("using value {} from config file for property {}", propertyValue, (Object)property);
            return propertyValue;
        }
        LOGGER.trace("no value provided as argument or in config file for property {}, using default value {}", (Object)property, defaultValue);
        return defaultValue;
    }

    public static synchronized boolean hasProperty(Property property) {
        return !MiscUtil.valueNullOrEmpty(RESOLVED_PROPERTIES.get((Object)property));
    }

    @Nullable
    public static synchronized <T> T getProperty(Property property) {
        return (T)RESOLVED_PROPERTIES.get((Object)property);
    }

    @Nullable
    public static synchronized String getStringProperty(Property property) {
        return SimpleConversions.convertToString(RESOLVED_PROPERTIES.get((Object)property));
    }

    @Nullable
    public static synchronized Integer getIntegerProperty(Property property) {
        return SimpleConversions.convertToInteger(RESOLVED_PROPERTIES.get((Object)property));
    }

    @Nullable
    public static synchronized Boolean getBooleanProperty(Property property) {
        return SimpleConversions.convertToBoolean(RESOLVED_PROPERTIES.get((Object)property));
    }

    public static Map<Property, Object> loadProperties(String filename, boolean addProperties) {
        InputStream input = ConfigLoader.class.getClassLoader().getResourceAsStream(filename);
        if (input != null) {
            return ConfigLoader.loadProperties(input, addProperties);
        }
        LOGGER.debug("Property file not found on classpath, skipping config file");
        return new HashMap<Property, Object>();
    }

    public static Map<Property, Object> loadProperties(Properties properties, boolean addProperties) {
        if (!addProperties) {
            RESOLVED_PROPERTIES.clear();
        }
        RESOLVED_PROPERTIES.putAll(ConfigLoader.readProperties(properties));
        return Collections.unmodifiableMap(RESOLVED_PROPERTIES);
    }

    public static Map<Property, Object> loadProperties(File filename, boolean addProperties) {
        try {
            return ConfigLoader.loadProperties(new FileInputStream(filename), addProperties);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("error reading properties file from File", e);
        }
    }

    public static synchronized Map<Property, Object> loadProperties(@Nullable InputStream inputStream, boolean addProperties) {
        Properties prop = new Properties();
        try {
            prop.load(MiscUtil.checkArgumentNotEmpty(inputStream, "InputStream was null"));
        }
        catch (IOException e) {
            throw new IllegalStateException("error reading properties file from inputstream", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!addProperties) {
            RESOLVED_PROPERTIES.clear();
        }
        RESOLVED_PROPERTIES.putAll(ConfigLoader.readProperties(prop));
        return Collections.unmodifiableMap(RESOLVED_PROPERTIES);
    }

    private static Map<Property, Object> readProperties(@NotNull Properties fileProperties) {
        Properties filePropertiesLeft = new Properties();
        filePropertiesLeft.putAll((Map<?, ?>)fileProperties);
        HashMap<Property, Object> resolvedProps = new HashMap<Property, Object>();
        for (Property prop : Property.values()) {
            Object asSystemProperty;
            if (System.getProperty(prop.key) != null) {
                LOGGER.debug(prop.key + ": " + System.getProperty(prop.key));
            }
            if ((asSystemProperty = ConfigLoader.parsePropertyValue(System.getProperty(prop.key))) != null) {
                resolvedProps.put(prop, asSystemProperty);
                filePropertiesLeft.remove(prop.key);
                continue;
            }
            Object asEnvProperty = ConfigLoader.parsePropertyValue(System.getenv().get(prop.key));
            if (asEnvProperty != null) {
                resolvedProps.put(prop, asEnvProperty);
                filePropertiesLeft.remove(prop.key);
                continue;
            }
            Object rawValue = filePropertiesLeft.remove(prop.key);
            if (rawValue == null) continue;
            if (rawValue instanceof String) {
                resolvedProps.put(prop, ConfigLoader.parsePropertyValue((String)rawValue));
                continue;
            }
            resolvedProps.put(prop, rawValue);
        }
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.putAll(ConfigLoader.filterExtraJavaMailProperties(null, System.getProperties().entrySet()));
        extraProperties.putAll(ConfigLoader.filterExtraJavaMailProperties(null, System.getenv().entrySet()));
        extraProperties.putAll(ConfigLoader.filterExtraJavaMailProperties(filePropertiesLeft, fileProperties.entrySet()));
        resolvedProps.put(Property.EXTRA_PROPERTIES, extraProperties);
        if (!filePropertiesLeft.isEmpty()) {
            throw new IllegalArgumentException("unknown properties provided " + filePropertiesLeft);
        }
        return resolvedProps;
    }

    private static Map<String, String> filterExtraJavaMailProperties(@Nullable Properties filePropertiesLeft, Set<Map.Entry<Object, Object>> entries) {
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> propertyKey : entries) {
            Matcher matcher;
            if (!(propertyKey.getKey() instanceof String) || !(matcher = EXTRA_PROPERTY_PATTERN.matcher((String)propertyKey.getKey())).matches()) continue;
            Preconditions.assumeTrue(propertyKey.getValue() instanceof String, "Simple Java Mail property value can only be of type String");
            extraProperties.put(matcher.group("actualProperty"), (String)propertyKey.getValue());
            if (filePropertiesLeft == null) continue;
            filePropertiesLeft.remove(propertyKey.getKey());
        }
        return extraProperties;
    }

    @Nullable
    static Object parsePropertyValue(@Nullable String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        HashMap<String, Boolean> booleanConversionMap = new HashMap<String, Boolean>();
        booleanConversionMap.put("0", false);
        booleanConversionMap.put("1", true);
        booleanConversionMap.put("false", false);
        booleanConversionMap.put("true", true);
        booleanConversionMap.put("no", false);
        booleanConversionMap.put("yes", true);
        if (booleanConversionMap.containsKey(propertyValue)) {
            return booleanConversionMap.get(propertyValue.toLowerCase());
        }
        try {
            return Integer.valueOf(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return TransportStrategy.valueOf(propertyValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ContentTransferEncoding.valueOf(propertyValue);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return DkimConfig.Canonicalization.valueOf(propertyValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            return LoadBalancingStrategy.valueOf(propertyValue);
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            return propertyValue;
                        }
                    }
                }
            }
        }
    }

    static {
        ConfigLoader.loadProperties(DEFAULT_CONFIG_FILENAME, false);
    }

    public static enum Property {
        JAVAXMAIL_DEBUG("simplejavamail.javaxmail.debug"),
        TRANSPORT_STRATEGY("simplejavamail.transportstrategy"),
        SMTP_HOST("simplejavamail.smtp.host"),
        SMTP_PORT("simplejavamail.smtp.port"),
        SMTP_USERNAME("simplejavamail.smtp.username"),
        SMTP_PASSWORD("simplejavamail.smtp.password"),
        DISABLE_ALL_CLIENTVALIDATION("simplejavamail.disable.all.clientvalidation"),
        CUSTOM_SSLFACTORY_CLASS("simplejavamail.custom.sslfactory.class"),
        PROXY_HOST("simplejavamail.proxy.host"),
        PROXY_PORT("simplejavamail.proxy.port"),
        PROXY_USERNAME("simplejavamail.proxy.username"),
        PROXY_PASSWORD("simplejavamail.proxy.password"),
        PROXY_SOCKS5BRIDGE_PORT("simplejavamail.proxy.socks5bridge.port"),
        DEFAULT_SUBJECT("simplejavamail.defaults.subject"),
        DEFAULT_CONTENT_TRANSFER_ENCODING("simplejavamail.defaults.content.transfer.encoding"),
        DEFAULT_FROM_NAME("simplejavamail.defaults.from.name"),
        DEFAULT_FROM_ADDRESS("simplejavamail.defaults.from.address"),
        DEFAULT_REPLYTO_NAME("simplejavamail.defaults.replyto.name"),
        DEFAULT_REPLYTO_ADDRESS("simplejavamail.defaults.replyto.address"),
        DEFAULT_BOUNCETO_NAME("simplejavamail.defaults.bounceto.name"),
        DEFAULT_BOUNCETO_ADDRESS("simplejavamail.defaults.bounceto.address"),
        DEFAULT_TO_NAME("simplejavamail.defaults.to.name"),
        DEFAULT_TO_ADDRESS("simplejavamail.defaults.to.address"),
        DEFAULT_CC_NAME("simplejavamail.defaults.cc.name"),
        DEFAULT_CC_ADDRESS("simplejavamail.defaults.cc.address"),
        DEFAULT_BCC_NAME("simplejavamail.defaults.bcc.name"),
        DEFAULT_BCC_ADDRESS("simplejavamail.defaults.bcc.address"),
        DEFAULT_POOL_SIZE("simplejavamail.defaults.poolsize"),
        DEFAULT_CONNECTIONPOOL_CLUSTER_KEY("simplejavamail.defaults.connectionpool.clusterkey.uuid"),
        DEFAULT_CONNECTIONPOOL_CORE_SIZE("simplejavamail.defaults.connectionpool.coresize"),
        DEFAULT_CONNECTIONPOOL_MAX_SIZE("simplejavamail.defaults.connectionpool.maxsize"),
        DEFAULT_CONNECTIONPOOL_CLAIMTIMEOUT_MILLIS("simplejavamail.defaults.connectionpool.claimtimeout.millis"),
        DEFAULT_CONNECTIONPOOL_EXPIREAFTER_MILLIS("simplejavamail.defaults.connectionpool.expireafter.millis"),
        DEFAULT_CONNECTIONPOOL_LOADBALANCING_STRATEGY("simplejavamail.defaults.connectionpool.loadbalancing.strategy"),
        DEFAULT_POOL_KEEP_ALIVE_TIME("simplejavamail.defaults.poolsize.keepalivetime"),
        DEFAULT_SESSION_TIMEOUT_MILLIS("simplejavamail.defaults.sessiontimeoutmillis"),
        DEFAULT_TRUST_ALL_HOSTS("simplejavamail.defaults.trustallhosts"),
        DEFAULT_TRUSTED_HOSTS("simplejavamail.defaults.trustedhosts"),
        DEFAULT_VERIFY_SERVER_IDENTITY("simplejavamail.defaults.verifyserveridentity"),
        TRANSPORT_MODE_LOGGING_ONLY("simplejavamail.transport.mode.logging.only"),
        OPPORTUNISTIC_TLS("simplejavamail.opportunistic.tls"),
        SMIME_SIGNING_KEYSTORE("simplejavamail.smime.signing.keystore"),
        SMIME_SIGNING_KEYSTORE_PASSWORD("simplejavamail.smime.signing.keystore_password"),
        SMIME_SIGNING_KEY_ALIAS("simplejavamail.smime.signing.key_alias"),
        SMIME_SIGNING_KEY_PASSWORD("simplejavamail.smime.signing.key_password"),
        SMIME_SIGNING_ALGORITHM("simplejavamail.smime.signing.algorithm"),
        SMIME_ENCRYPTION_KEY_ENCAPSULATION_ALGORITHM("simplejavamail.smime.encryption.key_encapsulation_algorithm"),
        SMIME_ENCRYPTION_CIPHER("simplejavamail.smime.encryption.cipher"),
        DKIM_PRIVATE_KEY_FILE_OR_DATA("simplejavamail.dkim.signing.private_key_file_or_data"),
        DKIM_SELECTOR("simplejavamail.dkim.signing.selector"),
        DKIM_SIGNING_DOMAIN("simplejavamail.dkim.signing.signing_domain"),
        DKIM_SIGNING_USE_LENGTH_PARAM("simplejavamail.dkim.signing.use_length_param"),
        DKIM_EXCLUDED_HEADERS_FROM_DEFAULT_SIGNING_LIST("simplejavamail.dkim.signing.excluded_headers_from_default_signing_list"),
        DKIM_SIGNING_HEADER_CANONICALIZATION("simplejavamail.dkim.signing.header_canonicalization"),
        DKIM_SIGNING_BODY_CANONICALIZATION("simplejavamail.dkim.signing.body_canonicalization"),
        DKIM_SIGNING_ALGORITHM("simplejavamail.dkim.signing.algorithm"),
        SMIME_ENCRYPTION_CERTIFICATE("simplejavamail.smime.encryption.certificate"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_DIR("simplejavamail.embeddedimages.dynamicresolution.enable.dir"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_CLASSPATH("simplejavamail.embeddedimages.dynamicresolution.enable.classpath"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_ENABLE_URL("simplejavamail.embeddedimages.dynamicresolution.enable.url"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_DIR("simplejavamail.embeddedimages.dynamicresolution.base.dir"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_CLASSPATH("simplejavamail.embeddedimages.dynamicresolution.base.classpath"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_BASE_URL("simplejavamail.embeddedimages.dynamicresolution.base.url"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_DIR("simplejavamail.embeddedimages.dynamicresolution.outside.base.dir"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_URL("simplejavamail.embeddedimages.dynamicresolution.outside.base.classpath"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_OUTSIDE_BASE_CLASSPATH("simplejavamail.embeddedimages.dynamicresolution.outside.base.url"),
        EMBEDDEDIMAGES_DYNAMICRESOLUTION_MUSTBESUCCESFUL("simplejavamail.embeddedimages.dynamicresolution.mustbesuccesful"),
        EXTRA_PROPERTIES("simplejavamail.extraproperties.*");

        private final String key;

        private Property(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

