/*
 * Copyright (C) 2009 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testutil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Test helper that can force disable modules that are on the classpath
 */
public class ModuleLoaderTestHelper {
	public static void _forceDisableBatchModule() {
		try {
			Class<?> classModuleLoader = Class.forName("org.simplejavamail.internal.modules.ModuleLoader");
			Method m = classModuleLoader.getDeclaredMethod("_forceDisableBatchModule");
			m.invoke(null);
		} catch (IllegalAccessException | InvocationTargetException | ClassNotFoundException | NoSuchMethodException e) {
			throw new RuntimeException("Exception trying to access ModuleLoader", e);
		}
	}
}
