/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.ajp;

import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class AjpPlugin
extends JettyConsolePluginBase {
    private int ajpPort;
    private StartOption ajpOption = new DefaultStartOption("ajpPort", "n", "Create an AJP listener on port n (default: don't listen on AJP)", "AJP"){

        public String validate(String value) {
            try {
                AjpPlugin.this.ajpPort = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return "--ajpPort option requires a numerical value between 1 and 65535";
            }
            return null;
        }
    };

    public AjpPlugin() {
        super(AjpPlugin.class.getName());
        this.addStartOptions(new StartOption[]{this.ajpOption});
    }

    public void customizeServer(Server server) {
        if (this.ajpPort > 0) {
            Ajp13SocketConnector ajpConnector = new Ajp13SocketConnector();
            ajpConnector.setPort(this.ajpPort);
            server.addConnector((Connector)ajpConnector);
        }
    }
}

