package org.simplericity.jettyconsole.api;

import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: bjorsnos
 * Date: May 25, 2009
 * Time: 8:10:21 PM
 * To change this template use File | Settings | File Templates.
 */
public interface JettyConsolePlugin {
    
     List<StartOption> getStartOptions();
     void beforeStart(WebAppContext context);
     void beforeStop(WebAppContext context);

     void customizeServer(Server server);

     void customizeRequest(EndPoint endpoint, Request request);

     void customizeConnector(SelectChannelConnector connector);

     void bootstrap();

     void configureConsole(Configuration configuration);
}
