/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.simplify4u.plugins.sign.ArtifactSigner;
import org.simplify4u.plugins.sign.ArtifactSignerFactory;
import org.simplify4u.plugins.sign.SignMojoException;
import org.simplify4u.plugins.sign.SignResult;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.simplify4u.plugins.sign.openpgp.PGPSignerKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SignMojo
extends AbstractMojo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SignMojo.class);
    @Inject
    private MavenProject project;
    @Inject
    private MavenProjectHelper projectHelper;
    @Inject
    private ArtifactSignerFactory artifactSignerFactory;
    @Inject
    private SecDispatcher secDispatcher;
    @Parameter(property="sign.keyId")
    private String keyId;
    @Parameter(property="sign.keyPass")
    private String keyPass;
    @Parameter(property="sign.keyFile", defaultValue="${user.home}/.m2/sign-key.asc")
    private File keyFile;
    @Parameter(property="sign.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="sign.skipNoKey", defaultValue="true")
    private boolean skipNoKey;

    public void execute() {
        PGPKeyInfo keyInfo;
        if (this.skip) {
            LOGGER.info("Sign - skip execution");
            return;
        }
        try {
            keyInfo = PGPKeyInfo.builder().passDecryptor(this::decryptPass).keyId(this.keyId).keyPass(this.keyPass).keyFile(this.keyFile).build();
        }
        catch (PGPSignerKeyNotFoundException e) {
            if (this.skipNoKey) {
                LOGGER.info("Sign - key not found - skip execution");
                return;
            }
            throw e;
        }
        ArtifactSigner artifactSigner = this.artifactSignerFactory.getSigner(keyInfo);
        HashSet<Object> artifactsToSign = new HashSet<Object>();
        artifactsToSign.add(new ProjectArtifact(this.project));
        artifactsToSign.add(this.project.getArtifact());
        artifactsToSign.addAll(this.project.getAttachedArtifacts());
        artifactsToSign.stream().map(artifactSigner::signArtifact).flatMap(Collection::stream).forEach(this::attachSignResult);
    }

    private String decryptPass(String pass) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> this.secDispatcher.decrypt(pass)).getOrElseThrow(e -> new SignMojoException("Invalid encrypted password", (Throwable)e));
    }

    private void attachSignResult(SignResult signResult) {
        LOGGER.info("Attach signature: {}", (Object)signResult);
        this.projectHelper.attachArtifact(this.project, signResult.getExtension(), signResult.getClassifier(), signResult.getFile());
    }

    @Generated
    void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    @Generated
    void setKeyFile(File keyFile) {
        this.keyFile = keyFile;
    }

    @Generated
    void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Generated
    void setSkipNoKey(boolean skipNoKey) {
        this.skipNoKey = skipNoKey;
    }
}

