/*
 * Copyright (c) 2015 EXILANT Technologies Private Limited (www.exilant.com)
 * Copyright (c) 2016 simplity.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.simplity.kernel;

import org.simplity.service.ServiceProtocol;

/**
 * <p>FilterCondition class.</p>
 *
 * @author rg bhandi
 * @version $Id: $Id
 */
public enum FilterCondition {
	/**
	 * equal
	 */
	Equal(ServiceProtocol.EQUAL),
	/**
	 * not equal
	 */
	NotEqual(ServiceProtocol.NOT_EQUAL),
	/**
	 * greater. remember it is greater and not "more"
	 */
	Greater(ServiceProtocol.GREATER),
	/**
	 * greater or equal
	 */
	GreaterOrEqual(ServiceProtocol.GREATER_OR_EQUAL),
	/**
	 * we prefer to call small rather than less because we say greater and not
	 * more :-)
	 */
	Smaller(ServiceProtocol.LESS),
	/**
	 * we prefer to smaller to less than more :-)
	 */
	SmallerOrEqual(ServiceProtocol.LESS_OR_EQUAL),
	/**
	 * like
	 */
	Like(ServiceProtocol.LIKE, FilterCondition.LIKE),
	/**
	 * starts with
	 */
	StartsWith(ServiceProtocol.STARTS_WITH, FilterCondition.LIKE),
	/**
	 * between
	 */
	Between(ServiceProtocol.BETWEEN, FilterCondition.BETWEEN),
	/**
	 * one in the list
	 */
	In(ServiceProtocol.IN_LIST, FilterCondition.IN);
	/** Constant <code>IN=" IN "</code> */
	private static final String IN = " IN ";
	private static final String LIKE = " LIKE ";
	private static final String BETWEEN = " BETWEEN ";
	private String textValue;
	private String sql;

	private FilterCondition(String text) {
		this.textValue = text;
		this.sql = text;
	}

	private FilterCondition(String text, String sqlText) {
		this.textValue = text;
		this.sql = sqlText;
	}

	/**
	 * parse a text into enum
	 *
	 * @param text
	 *            text to be parsed into enum
	 * @return filter condition, or null if there is no filter for this text
	 */
	public static FilterCondition parse(String text) {
		if (text == null || text.length() == 0) {
			return Equal;
		}
		for (FilterCondition f : FilterCondition.values()) {
			if (f.textValue.equals(text)) {
				return f;
			}
		}
		return null;
	}

	/**
	 * <p>Getter for the field <code>sql</code>.</p>
	 *
	 * @return text to be used in a sql for this condition. like, startWith and
	 *         between require custom logic by caller
	 */
	public String getSql() {
		return this.sql;
	}
}
