/*
 * Copyright (c) 2015 EXILANT Technologies Private Limited (www.exilant.com)
 * Copyright (c) 2016 simplity.org
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.simplity.kernel.expr;

/**
 * all character definitions used in expression and operators
 *
 * @author simplity.org
 *
 */
@SuppressWarnings("javadoc")
public class Chars {
	public static final char SPACE = ' ';
	public static final char TAB = '\t';
	public static final char NL = '\n';
	public static final char CR = '\r';
	public static final char OPEN_CURVE = '(';
	public static final char CLOSE_CURVE = ')';
	public static final char OPEN_FLOWER = '{';
	public static final char CLOSE_FLOWER = '}';
	public static final char OPEN_SQUARE = '[';
	public static final char CLOSE_SQUARE = ']';
	public static final char SINGLE_QUOTE = '\'';
	public static final char DOUBLE_QUOTE = '"';
	public static final char ZERO = '0';
	public static final char NINE = '9';
	public static final char LOWER_A = 'a';
	public static final char UPPER_A = 'A';
	public static final char LOWER_Z = 'z';
	public static final char UPPER_Z = 'Z';
	public static final char PLUS = '+';
	public static final char MINUS = '-';
	public static final char MULT = '*';
	public static final char DIVIDE = '/';
	public static final char MODULO = '%';
	public static final char IS_KNOWN = '?';
	public static final char NOT = '!';
	public static final char IS_UNKNOWN = '~';
	public static final char LESS = '<';
	public static final char GREATER = '>';
	public static final char EQUAL = '=';
	public static final char AND = '&';
	public static final char OR = '|';
	public static final char LIST = ',';
	public static final char DOT = '.';
	public static final char UNDER_SCORE = '_';
	public static final char NOT_EQUAL = 'N';
	public static final char LESS_OR_EQUAL = 'L';
	public static final char GREATER_OR_EQUAL = 'G';

}
