/*
 * Copyright (c) 2015 EXILANT Technologies Private Limited (www.exilant.com)
 * Copyright (c) 2016 simplity.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.simplity.kernel.expr;

/**
 * Represents an exceptional condition that an operator is invalid for the value
 * type that it is to operate on
 *
 * @author simplity.org
 *
 */
public class InvalidExpressionException extends Exception {

	private static final long serialVersionUID = 1L;
	private String message;

	protected InvalidExpressionException(String expression, String error,
			int position) {
		StringBuilder msg = new StringBuilder(
				"Error encountered while parsing. ");

		if (expression == null || expression.length() == 0) {
			msg.append(error);
		} else {
			msg.append('\n').append("expression : ").append(expression)
					.append('\n');
			if (position >= expression.length()) {
				msg.append("Unexpected end of expression. ").append(error);
			} else {
				msg.append("parsed up to ")
						.append(expression.substring(0, position)).append('\n')
						.append(error);
			}
		}
		this.message = msg.toString();
	}

	@Override
	public String getMessage() {
		return this.message;
	}
}
