/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.money;

import java.util.Currency;
import java.util.Locale;
import org.sisioh.baseunits.scala.money.Money;
import scala.Enumeration;
import scala.Function2;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;

public final class Money$
implements Serializable {
    public static final Money$ MODULE$;
    private final Currency USD;
    private final Currency EUR;
    private final Currency JPY;
    private final Enumeration.Value DefaultRoundingMode;

    static {
        new Money$();
    }

    public Currency USD() {
        return this.USD;
    }

    public Currency EUR() {
        return this.EUR;
    }

    public Currency JPY() {
        return this.JPY;
    }

    public Enumeration.Value DefaultRoundingMode() {
        return this.DefaultRoundingMode;
    }

    public Money apply(BigDecimal amount, Currency currency) {
        return new Money(amount, currency);
    }

    public Option<Tuple2<BigDecimal, Currency>> unapply(Money money) {
        return new Some((Object)new Tuple2((Object)money.amount(), (Object)money.currency()));
    }

    public Money dollars(BigDecimal amount) {
        return this.adjustBy(amount, this.USD());
    }

    public Money dollars(double amount) {
        return this.adjustBy(amount, this.USD());
    }

    public Money euros(BigDecimal amount) {
        return this.adjustBy(amount, this.EUR());
    }

    public Money euros(double amount) {
        return this.adjustBy(amount, this.EUR());
    }

    public Money sum(Iterable<Money> monies) {
        return monies.isEmpty() ? this.zero(Currency.getInstance(Locale.getDefault())) : (Money)monies.reduceLeft((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Money apply(Money x$1, Money x$2) {
                return x$1.$plus(x$2);
            }
        });
    }

    public Money adjustBy(BigDecimal amount, Currency currency) {
        return this.adjustBy(amount, currency, BigDecimal.RoundingMode$.MODULE$.UNNECESSARY());
    }

    public Money adjustBy(BigDecimal rawAmount, Currency currency, Enumeration.Value roundingMode) {
        BigDecimal amount = rawAmount.setScale(currency.getDefaultFractionDigits(), roundingMode);
        return new Money(amount, currency);
    }

    public Money adjustBy(double dblAmount, Currency currency) {
        return this.adjustBy(BigDecimal$.MODULE$.double2bigDecimal(dblAmount), currency, this.DefaultRoundingMode());
    }

    public Money adjustRound(double dblAmount, Currency currency, Enumeration.Value roundingMode) {
        BigDecimal rawAmount = package$.MODULE$.BigDecimal().apply(dblAmount);
        return this.adjustBy(rawAmount, currency, roundingMode);
    }

    public Money yens(BigDecimal amount) {
        return this.adjustBy(amount, this.JPY());
    }

    public Money yens(double amount) {
        return this.adjustBy(amount, this.JPY());
    }

    public Money zero(Currency currency) {
        return this.adjustBy(0.0, currency);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Money$() {
        MODULE$ = this;
        this.USD = Currency.getInstance("USD");
        this.EUR = Currency.getInstance("EUR");
        this.JPY = Currency.getInstance("JPY");
        this.DefaultRoundingMode = BigDecimal.RoundingMode$.MODULE$.HALF_EVEN();
    }
}

