/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.time.CalendarDate;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.CalendarYearMonth$;
import org.sisioh.baseunits.scala.time.DayOfMonth;
import org.sisioh.baseunits.scala.time.DayOfMonth$;
import org.sisioh.baseunits.scala.time.MonthOfYear;
import org.sisioh.baseunits.scala.time.TimePoint;
import org.sisioh.baseunits.scala.time.TimePoint$;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;

public final class CalendarDate$
implements Serializable {
    public static final CalendarDate$ MODULE$;

    static {
        new CalendarDate$();
    }

    public CalendarDate apply(CalendarYearMonth yearMonth, DayOfMonth day) {
        return this.from(yearMonth, day, yearMonth.zoneId());
    }

    public Option<Tuple3<CalendarYearMonth, DayOfMonth, TimeZone>> unapply(CalendarDate calendarDate) {
        return new Some((Object)new Tuple3((Object)calendarDate.yearMonth(), (Object)calendarDate.day(), (Object)TimeZone.getTimeZone(calendarDate.zoneId())));
    }

    public CalendarDate from(CalendarYearMonth yearMonth, DayOfMonth day) {
        return this.from(yearMonth, day, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate from(CalendarYearMonth yearMonth, DayOfMonth day, TimeZone timeZone) {
        return new CalendarDate(yearMonth, day, timeZone.toZoneId());
    }

    public CalendarDate from(CalendarYearMonth yearMonth, DayOfMonth day, ZoneId zoneId) {
        return new CalendarDate(yearMonth, day, zoneId);
    }

    public CalendarDate from(int year, int month, int day) {
        return this.from(year, month, day, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate from(int year, int month, int day, TimeZone timeZone) {
        return new CalendarDate(CalendarYearMonth$.MODULE$.from(year, month, timeZone.toZoneId()), DayOfMonth$.MODULE$.apply(day), timeZone.toZoneId());
    }

    public CalendarDate from(int year, int month, int day, ZoneId zoneId) {
        return new CalendarDate(CalendarYearMonth$.MODULE$.from(year, month, zoneId), DayOfMonth$.MODULE$.apply(day), zoneId);
    }

    public CalendarDate from(int year, MonthOfYear month, DayOfMonth day) {
        return this.from(year, month, day, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate from(int year, MonthOfYear month, DayOfMonth day, TimeZone timeZone) {
        return this.from(CalendarYearMonth$.MODULE$.from(year, month, timeZone.toZoneId()), day, timeZone.toZoneId());
    }

    public CalendarDate from(int year, MonthOfYear month, DayOfMonth day, ZoneId zoneId) {
        return this.from(CalendarYearMonth$.MODULE$.from(year, month, zoneId), day, zoneId);
    }

    public CalendarDate from(TimePoint timePoint) {
        return this.from(timePoint, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate from(TimePoint timePoint, TimeZone timeZone) {
        return this.from(timePoint, timeZone.toZoneId());
    }

    public CalendarDate from(TimePoint timePoint, ZoneId zoneId) {
        ZonedDateTime calendar = timePoint.asJavaZonedDateTime(zoneId);
        return this.from(calendar);
    }

    public CalendarDate from(LocalDate localDate, ZoneId zoneId) {
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        int day = localDate.getDayOfMonth();
        return this.from(year, month, day, zoneId);
    }

    public CalendarDate parse(String dateString, String pattern, TimeZone timeZone) {
        TimePoint point = TimePoint$.MODULE$.parse(dateString, pattern, timeZone);
        return this.from(point, timeZone);
    }

    public CalendarDate parse(String dateString, String pattern, ZoneId zoneId) {
        TimePoint point = TimePoint$.MODULE$.parse(dateString, pattern, zoneId);
        return this.from(point, zoneId);
    }

    public CalendarDate parse(String dateString, String pattern) {
        return this.parse(dateString, pattern, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate from(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        return this.from(year, month, date, calendar.getTimeZone().toZoneId());
    }

    public CalendarDate from(ZonedDateTime zonedDateTime) {
        int year = zonedDateTime.getYear();
        int month = zonedDateTime.getMonthValue();
        int date = zonedDateTime.getDayOfMonth();
        return this.from(year, month, date, zonedDateTime.getZone());
    }

    public ZoneId from$default$2() {
        return ZoneIds$.MODULE$.Default();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CalendarDate$() {
        MODULE$ = this;
    }
}

