/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.intervals.Limit;
import org.sisioh.baseunits.scala.time.CalendarDate$;
import org.sisioh.baseunits.scala.time.CalendarDateTime;
import org.sisioh.baseunits.scala.time.CalendarDateTime$;
import org.sisioh.baseunits.scala.time.CalendarInterval;
import org.sisioh.baseunits.scala.time.CalendarInterval$;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.DayOfMonth;
import org.sisioh.baseunits.scala.time.DayOfWeek;
import org.sisioh.baseunits.scala.time.DayOfWeek$;
import org.sisioh.baseunits.scala.time.Duration;
import org.sisioh.baseunits.scala.time.Duration$;
import org.sisioh.baseunits.scala.time.MonthOfYear;
import org.sisioh.baseunits.scala.time.TimeInterval;
import org.sisioh.baseunits.scala.time.TimeInterval$;
import org.sisioh.baseunits.scala.time.TimeOfDay;
import org.sisioh.baseunits.scala.time.TimePoint;
import org.sisioh.baseunits.scala.time.TimePoint$;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r]d\u0001B\u0001\u0003\u00015\u0011AbQ1mK:$\u0017M\u001d#bi\u0016T!a\u0001\u0003\u0002\tQLW.\u001a\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0013\t\f7/Z;oSR\u001c(BA\u0005\u000b\u0003\u0019\u0019\u0018n]5pQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dM\t\u0003CA\b\u0012\u001b\u0005\u0001\"\"A\u0003\n\u0005I\u0001\"AB!osJ+g\rE\u0002\u00159}q!!\u0006\u000e\u000f\u0005YIR\"A\f\u000b\u0005aa\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\tY\u0002#A\u0004qC\u000e\\\u0017mZ3\n\u0005uq\"aB(sI\u0016\u0014X\r\u001a\u0006\u00037A\u0001\"\u0001\t\u0001\u000e\u0003\t\u0001\"a\u0004\u0012\n\u0005\r\u0002\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0013e,\u0017M]'p]RDW#A\u0014\u0011\u0005\u0001B\u0013BA\u0015\u0003\u0005E\u0019\u0015\r\\3oI\u0006\u0014\u0018,Z1s\u001b>tG\u000f\u001b\u0005\tW\u0001\u0011\t\u0011)A\u0005O\u0005Q\u00110Z1s\u001b>tG\u000f\u001b\u0011\t\u00115\u0002!Q1A\u0005\u00029\n1\u0001Z1z+\u0005y\u0003C\u0001\u00111\u0013\t\t$A\u0001\u0006ECf|e-T8oi\"D\u0001b\r\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0005I\u0006L\b\u0005\u0003\u00056\u0001\t\u0015\r\u0011\"\u00017\u0003\u0019QxN\\3JIV\tq\u0007\u0005\u00029y5\t\u0011H\u0003\u0002\u0004u)\t1(\u0001\u0003kCZ\f\u0017BA\u001f:\u0005\u0019QvN\\3JI\"Aq\b\u0001B\u0001B\u0003%q'A\u0004{_:,\u0017\n\u001a\u0011\t\r\u0005\u0003A\u0011\u0001\u0002C\u0003\u0019a\u0014N\\5u}Q!qd\u0011#F\u0011\u0015)\u0003\t1\u0001(\u0011\u0015i\u0003\t1\u00010\u0011\u0015)\u0004\t1\u00018\u0011!9\u0005\u0001#b\u0001\n\u0003A\u0015aC1t\u0019>\u001c\u0017\r\u001c#bi\u0016,\u0012!\u0013\t\u0003q)K!aS\u001d\u0003\u00131{7-\u00197ECR,\u0007\u0002C'\u0001\u0011\u0003\u0005\u000b\u0015B%\u0002\u0019\u0005\u001cHj\\2bY\u0012\u000bG/\u001a\u0011\t\u000b=\u0003A\u0011\t)\u0002\u000f\r|W\u000e]1sKR\u0011\u0011\u000b\u0016\t\u0003\u001fIK!a\u0015\t\u0003\u0007%sG\u000fC\u0003V\u001d\u0002\u0007q$A\u0003pi\",'\u000fC\u0003X\u0001\u0011\u0005a%A\bbg\u000e\u000bG.\u001a8eCJluN\u001c;i\u0011\u0015I\u0006\u0001\"\u0001[\u0003=\t7/T8oi\"Le\u000e^3sm\u0006dW#A.\u0011\u0005\u0001b\u0016BA/\u0003\u0005A\u0019\u0015\r\\3oI\u0006\u0014\u0018J\u001c;feZ\fG\u000eC\u0003`\u0001\u0011\u0005\u0001-\u0001\bbgRKW.Z%oi\u0016\u0014h/\u00197\u0015\u0005\u0005$\u0007C\u0001\u0011c\u0013\t\u0019'A\u0001\u0007US6,\u0017J\u001c;feZ\fG\u000eC\u0003f=\u0002\u0007a-\u0001\u0005uS6,'l\u001c8f!\t9'.D\u0001i\u0015\tI'(\u0001\u0003vi&d\u0017BA6i\u0005!!\u0016.\\3[_:,\u0007\u0006\u00020naJ\u0004\"a\u00048\n\u0005=\u0004\"A\u00033faJ,7-\u0019;fI\u0006\n\u0011/A\u0019Vg\u0016\u0004\u0013m\u001d+j[\u0016Le\u000e^3sm\u0006d\u0007F_8oK&#'\b\t.p]\u0016LE-\u000b\u0011nKRDw\u000e\u001a\u0011j]N$X-\u00193\"\u0003M\fa\u0001\r\u00182]EB\u0004\"B0\u0001\t\u0003)HCA1w\u0011\u001d)D\u000f%AA\u0002]B\u0001\u0002\u001f\u0001\t\u0006\u0004%\tAW\u0001\u000fCNLV-\u0019:J]R,'O^1m\u0011!Q\b\u0001#A!B\u0013Y\u0016aD1t3\u0016\f'/\u00138uKJ4\u0018\r\u001c\u0011\t\u000bq\u0004A\u0011A?\u0002%\u0005$8)\u00197f]\u0012\f'\u000fR1uKRKW.\u001a\u000b\u0004}\u0006\r\u0001C\u0001\u0011\u0000\u0013\r\t\tA\u0001\u0002\u0011\u0007\u0006dWM\u001c3be\u0012\u000bG/\u001a+j[\u0016Dq!!\u0002|\u0001\u0004\t9!A\u0005uS6,wJ\u001a#bsB\u0019\u0001%!\u0003\n\u0007\u0005-!AA\u0005US6,wJ\u001a#bs\"A\u0011q\u0002\u0001C\u0002\u0013\u0005a&\u0001\rce\u0016\f7\r[#oG\u0006\u00048/\u001e7bi&|gn\u00144ECfDc!!\u0004n\u0003'\u0011\u0018EAA\u000b\u0003a)6/\u001a\u0011eCf\u0004\u0003O]8qKJ$\u0018\u0010I5ogR,\u0017\r\u001a\u0005\b\u00033\u0001\u0001\u0015!\u00030\u0003e\u0011'/Z1dQ\u0016s7-\u00199tk2\fG/[8o\u001f\u001a$\u0015-\u001f\u0011\t\u0011\u0005u\u0001A1A\u0005\u0002\u0019\naD\u0019:fC\u000eDWI\\2baN,H.\u0019;j_:|e-W3be6{g\u000e\u001e5)\r\u0005mQ.!\tsC\t\t\u0019#\u0001\u0010Vg\u0016\u0004\u00130Z1s\u001b>tG\u000f\u001b\u0011qe>\u0004XM\u001d;zA%t7\u000f^3bI\"9\u0011q\u0005\u0001!\u0002\u00139\u0013a\b2sK\u0006\u001c\u0007.\u00128dCB\u001cX\u000f\\1uS>twJZ-fCJluN\u001c;iA!Q\u00111\u0006\u0001\t\u0006\u0004%\t!!\f\u0002\u0013\u0011\f\u0017p\u00144XK\u0016\\WCAA\u0018!\r\u0001\u0013\u0011G\u0005\u0004\u0003g\u0011!!\u0003#bs>3w+Z3l\u0011)\t9\u0004\u0001E\u0001B\u0003&\u0011qF\u0001\u000bI\u0006LxJZ,fK.\u0004\u0003bBA\u001e\u0001\u0011\u0005\u0013QH\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0012Q\t\t\u0004\u001f\u0005\u0005\u0013bAA\"!\t9!i\\8mK\u0006t\u0007\u0002CA$\u0003s\u0001\r!!\u0013\u0002\u0007=\u0014'\u000eE\u0002\u0010\u0003\u0017J1!!\u0014\u0011\u0005\r\te.\u001f\u0005\b\u0003#\u0002A\u0011IA*\u0003!A\u0017m\u001d5D_\u0012,G#A)\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\u00059\u0011n]!gi\u0016\u0014H\u0003BA \u00037Ba!VA+\u0001\u0004y\u0002bBA0\u0001\u0011\u0005\u0011\u0011M\u0001\tSN\u0014UMZ8sKR!\u0011qHA2\u0011\u0019)\u0016Q\fa\u0001?!9\u0011q\r\u0001\u0005\u0002\u0005%\u0014\u0001\u00029mkN$2aHA6\u0011!\ti'!\u001aA\u0002\u0005=\u0014A\u00027f]\u001e$\b\u000eE\u0002!\u0003cJ1!a\u001d\u0003\u0005!!UO]1uS>t\u0007bBA<\u0001\u0011\u0005\u0011\u0011P\u0001\u0006[&tWo\u001d\u000b\u0004?\u0005m\u0004\u0002CA7\u0003k\u0002\r!a\u001c\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006A\u0001\u000f\\;t\t\u0006L8\u000fF\u0002 \u0003\u0007Cq!!\"\u0002~\u0001\u0007\u0011+A\u0005j]\u000e\u0014X-\\3oi\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015!C7j]V\u001cH)Y=t)\ry\u0012Q\u0012\u0005\b\u0003\u001f\u000b9\t1\u0001R\u0003%!Wm\u0019:f[\u0016tG\u000fC\u0004\u0002\u0014\u0002!\t!!&\u0002\u0015AdWo]'p]RD7\u000fF\u0002 \u0003/Cq!!\"\u0002\u0012\u0002\u0007\u0011\u000bC\u0004\u0002\u001c\u0002!\t!!(\u0002\u00175Lg.^:N_:$\bn\u001d\u000b\u0004?\u0005}\u0005bBAH\u00033\u0003\r!\u0015\u0005\u000b\u0003G\u0003\u0001R1A\u0005\u0002\u0005\u0015\u0016a\u00028fqR$\u0015-_\u000b\u0002?!I\u0011\u0011\u0016\u0001\t\u0002\u0003\u0006KaH\u0001\t]\u0016DH\u000fR1zA!Q\u0011Q\u0016\u0001\t\u0006\u0004%\t!!*\u0002\u0017A\u0014XM^5pkN$\u0015-\u001f\u0005\n\u0003c\u0003\u0001\u0012!Q!\n}\tA\u0002\u001d:fm&|Wo\u001d#bs\u0002Bq!!.\u0001\t\u0003\t9,\u0001\tti\u0006\u0014H/Q:US6,\u0007k\\5oiR!\u0011\u0011XA`!\r\u0001\u00131X\u0005\u0004\u0003{\u0013!!\u0003+j[\u0016\u0004v.\u001b8u\u0011\u0019)\u00171\u0017a\u0001M\"2\u00111W7\u0002DJ\f#!!2\u0002gU\u001bX\rI:uCJ$\u0018i\u001d+j[\u0016\u0004v.\u001b8uQi|g.Z%eu\u0001RvN\\3JI&\u0002S.\u001a;i_\u0012\u0004\u0013N\\:uK\u0006$\u0007bBA[\u0001\u0011\u0005\u0011\u0011\u001a\u000b\u0005\u0003s\u000bY\r\u0003\u00056\u0003\u000f\u0004\n\u00111\u00018\u0011\u001d\ty\r\u0001C\u0001\u0003#\fq\u0001\u001e5s_V<\u0007\u000eF\u0002\\\u0003'Dq!!6\u0002N\u0002\u0007q$A\u0005pi\",'\u000fR1uK\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0007\u0003BAp\u0003Kt1aDAq\u0013\r\t\u0019\u000fE\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\b\u0003C\u0004\u0002Z\u0002!\t!!<\u0015\t\u0005u\u0017q\u001e\u0005\t\u0003c\fY\u000f1\u0001\u0002^\u00069\u0001/\u0019;uKJt\u0007\u0006CAv\u0003k\u0014\tAa\u0001\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?;\u0003\u0011a\u0017M\\4\n\t\u0005}\u0018\u0011 \u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d#A!\u0002\"\u0005\t\u001d\u0011a\u00033faJ,7-\u0019;j_:D1Ba\u0003\u0001\u0011\u000b\u0007I\u0011\u0001\u0002\u0003\u000e\u0005A\u0012m\u001d&bm\u0006\u001c\u0015\r\\3oI\u0006\u0014xJ\\'jI:Lw\r\u001b;\u0016\u0005\t=\u0001cA4\u0003\u0012%\u0019!1\u00035\u0003\u0011\r\u000bG.\u001a8eCJDcA!\u0003n\u0005/\u0011\u0018E\u0001B\r\u0003I*6/\u001a\u0011bg*\u000bg/\u0019.p]\u0016$G)\u0019;f)&lWm\u00148NS\u0012t\u0017n\u001a5uAA\u0014x\u000e]3sif\u0004\u0013N\\:uK\u0006$\u0007B\u0003B\u000f\u0001!\u0005\t\u0015)\u0003\u0003\u0010\u0005I\u0012m\u001d&bm\u0006\u001c\u0015\r\\3oI\u0006\u0014xJ\\'jI:Lw\r\u001b;!Q!\u0011Y\"!>\u0003\u0002\t\u0005BF\u0001B\u0003\u0011!\u0011Y\u0001\u0001C\u0001\u0005\t\u0015B\u0003\u0002B\b\u0005OAa!\u001aB\u0012\u0001\u00041\u0007F\u0002B\u0012[\n-\"/\t\u0002\u0003.\u0005\u0001Tk]3!CNT\u0015M^1[_:,G\rR1uKRKW.Z(o\u001b&$g.[4ii\u0002jW\r\u001e5pI\u0002Jgn\u001d;fC\u0012D1B!\r\u0001\u0011\u000b\u0007I\u0011\u0001\u0002\u00034\u0005i\u0012m\u001d&bm\u0006TvN\\3e\t\u0006$X\rV5nK>sW*\u001b3oS\u001eDG/\u0006\u0002\u00036A\u0019\u0001Ha\u000e\n\u0007\te\u0012HA\u0007[_:,G\rR1uKRKW.\u001a\u0005\u000b\u0005{\u0001\u0001\u0012!Q!\n\tU\u0012AH1t\u0015\u00064\u0018MW8oK\u0012$\u0015\r^3US6,wJ\\'jI:Lw\r\u001b;!\u0011!\u0011\t\u0004\u0001C\u0001\u0005\t\u0005C\u0003\u0002B\u001b\u0005\u0007Ba!\u000eB \u0001\u00049\u0004\"\u0003B$\u0001E\u0005I\u0011\u0001B%\u0003i\u0019H/\u0019:u\u0003N$\u0016.\\3Q_&tG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YEK\u00028\u0005\u001bZ#Aa\u0014\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053\u0002\u0012AC1o]>$\u0018\r^5p]&!!Q\fB*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005C\u0002\u0011\u0013!C\u0001\u0005\u0013\n\u0001$Y:US6,\u0017J\u001c;feZ\fG\u000e\n3fM\u0006,H\u000e\u001e\u00132\u000f\u001d\u0011)G\u0001E\u0001\u0005O\nAbQ1mK:$\u0017M\u001d#bi\u0016\u00042\u0001\tB5\r\u0019\t!\u0001#\u0001\u0003lM!!\u0011\u000e\b\"\u0011\u001d\t%\u0011\u000eC\u0001\u0005_\"\"Aa\u001a\t\u0011\tM$\u0011\u000eC\u0001\u0005k\nQ!\u00199qYf$Ra\bB<\u0005sBa!\nB9\u0001\u00049\u0003BB\u0017\u0003r\u0001\u0007q\u0006\u0003\u0005\u0003~\t%D\u0011\u0001B@\u0003\u001d)h.\u00199qYf$BA!!\u0003\u000eB)qBa!\u0003\b&\u0019!Q\u0011\t\u0003\r=\u0003H/[8o!\u0019y!\u0011R\u00140M&\u0019!1\u0012\t\u0003\rQ+\b\u000f\\34\u0011\u001d\u0011yIa\u001fA\u0002}\tAbY1mK:$\u0017M\u001d#bi\u0016D\u0001Ba%\u0003j\u0011\u0005!QS\u0001\u0005MJ|W\u000eF\u0003 \u0005/\u0013I\n\u0003\u0004&\u0005#\u0003\ra\n\u0005\u0007[\tE\u0005\u0019A\u0018\t\u0011\tM%\u0011\u000eC\u0001\u0005;#ra\bBP\u0005C\u0013\u0019\u000b\u0003\u0004&\u00057\u0003\ra\n\u0005\u0007[\tm\u0005\u0019A\u0018\t\r\u0015\u0014Y\n1\u0001g\u0011!\u0011\u0019J!\u001b\u0005\u0002\t\u001dFcB\u0010\u0003*\n-&Q\u0016\u0005\u0007K\t\u0015\u0006\u0019A\u0014\t\r5\u0012)\u000b1\u00010\u0011\u0019)$Q\u0015a\u0001o!A!1\u0013B5\t\u0003\u0011\t\fF\u0004 \u0005g\u00139La/\t\u000f\tU&q\u0016a\u0001#\u0006!\u00110Z1s\u0011\u001d\u0011ILa,A\u0002E\u000bQ!\\8oi\"Da!\fBX\u0001\u0004\t\u0006\u0002\u0003BJ\u0005S\"\tAa0\u0015\u0013}\u0011\tMa1\u0003F\n\u001d\u0007b\u0002B[\u0005{\u0003\r!\u0015\u0005\b\u0005s\u0013i\f1\u0001R\u0011\u0019i#Q\u0018a\u0001#\"1QM!0A\u0002\u0019DcA!0n\u0005\u0017\u0014\u0018E\u0001Bg\u0003!+6/\u001a\u0011ge>l\u0007&_3bej\u0002\u0013J\u001c;-A5|g\u000e\u001e5;A%sG\u000f\f\u0011eCfT\u0004%\u00138uY\u0001RxN\\3JIj\u0002#l\u001c8f\u0013\u0012L\u0003%\\3uQ>$\u0007%\u001b8ti\u0016\fG\r\u0003\u0005\u0003\u0014\n%D\u0011\u0001Bi)%y\"1\u001bBk\u0005/\u0014I\u000eC\u0004\u00036\n=\u0007\u0019A)\t\u000f\te&q\u001aa\u0001#\"1QFa4A\u0002ECa!\u000eBh\u0001\u00049\u0004\u0002\u0003BJ\u0005S\"\tA!8\u0015\u000f}\u0011yN!9\u0003j\"9!Q\u0017Bn\u0001\u0004\t\u0006\u0002\u0003B]\u00057\u0004\rAa9\u0011\u0007\u0001\u0012)/C\u0002\u0003h\n\u00111\"T8oi\"|e-W3be\"1QFa7A\u0002=B\u0001Ba%\u0003j\u0011\u0005!Q\u001e\u000b\n?\t=(\u0011\u001fBz\u0005kDqA!.\u0003l\u0002\u0007\u0011\u000b\u0003\u0005\u0003:\n-\b\u0019\u0001Br\u0011\u0019i#1\u001ea\u0001_!1QMa;A\u0002\u0019DcAa;n\u0005s\u0014\u0018E\u0001B~\u0003]+6/\u001a\u0011ge>l\u0007&_3bej\u0002\u0013J\u001c;-A5|g\u000e\u001e5;A5{g\u000e\u001e5PMf+\u0017M\u001d\u0017!I\u0006L(\b\t#bs>3Wj\u001c8uQ2\u0002#p\u001c8f\u0013\u0012T\u0004EW8oK&#\u0017\u0006I7fi\"|G\rI5ogR,\u0017\r\u001a\u0005\t\u0005'\u0013I\u0007\"\u0001\u0003\u0000RIqd!\u0001\u0004\u0004\r\u00151q\u0001\u0005\b\u0005k\u0013i\u00101\u0001R\u0011!\u0011IL!@A\u0002\t\r\bBB\u0017\u0003~\u0002\u0007q\u0006\u0003\u00046\u0005{\u0004\ra\u000e\u0005\t\u0005'\u0013I\u0007\"\u0001\u0004\fQ\u0019qd!\u0004\t\u0011\r=1\u0011\u0002a\u0001\u0003s\u000b\u0011\u0002^5nKB{\u0017N\u001c;\t\u0011\tM%\u0011\u000eC\u0001\u0007'!RaHB\u000b\u0007/A\u0001ba\u0004\u0004\u0012\u0001\u0007\u0011\u0011\u0018\u0005\u0007K\u000eE\u0001\u0019\u00014)\r\rEQna\u0007sC\t\u0019i\"A\u001fVg\u0016\u0004cM]8nQQLW.\u001a)pS:$(\b\t+j[\u0016\u0004v.\u001b8uY\u0001RxN\\3JIj\u0002#l\u001c8f\u0013\u0012L\u0003%\\3uQ>$\u0007%\u001b8ti\u0016\fG\r\u0003\u0005\u0003\u0014\n%D\u0011AB\u0011)\u0015y21EB\u0013\u0011!\u0019yaa\bA\u0002\u0005e\u0006BB\u001b\u0004 \u0001\u0007q\u0007\u0003\u0005\u0003\u0014\n%D\u0011AB\u0015)\u0015y21FB\u0018\u0011\u001d\u0019ica\nA\u0002%\u000b\u0011\u0002\\8dC2$\u0015\r^3\t\u0011U\u001a9\u0003%AA\u0002]B\u0001ba\r\u0003j\u0011\u00051QG\u0001\u0006a\u0006\u00148/\u001a\u000b\b?\r]21HB\u001f\u0011!\u0019Id!\rA\u0002\u0005u\u0017A\u00033bi\u0016\u001cFO]5oO\"A\u0011\u0011_B\u0019\u0001\u0004\ti\u000e\u0003\u0004f\u0007c\u0001\rA\u001a\u0015\u0007\u0007ci7\u0011\t:\"\u0005\r\r\u0013!T+tK\u0002\u0002\u0018M]:fQ\u0011\fG/Z*ue&twM\u000f\u0011TiJLgn\u001a\u0017!a\u0006$H/\u001a:ou\u0001\u001aFO]5oO2\u0002#p\u001c8f\u0013\u0012T\u0004EW8oK&#\u0017\u0006I7fi\"|G\rI5ogR,\u0017\r\u001a\u0005\t\u0007g\u0011I\u0007\"\u0001\u0004HQ9qd!\u0013\u0004L\r5\u0003\u0002CB\u001d\u0007\u000b\u0002\r!!8\t\u0011\u0005E8Q\ta\u0001\u0003;Da!NB#\u0001\u00049\u0004\u0002CB\u001a\u0005S\"\ta!\u0015\u0015\u000b}\u0019\u0019f!\u0016\t\u0011\re2q\na\u0001\u0003;D\u0001\"!=\u0004P\u0001\u0007\u0011Q\u001c\u0005\n\u0005'\u0013I\u0007\"\u0001\u0003\u00073\"2aHB.\u0011!\u0019ifa\u0016A\u0002\t=\u0011\u0001C2bY\u0016tG-\u0019:\t\u0013\tM%\u0011\u000eC\u0001\u0005\r\u0005DcA\u0010\u0004d!A1QMB0\u0001\u0004\u0011)$A\u0007{_:,G\rR1uKRKW.\u001a\u0005\u000b\u0007S\u0012I'%A\u0005\u0002\t%\u0013A\u00044s_6$C-\u001a4bk2$HE\r\u0005\u000b\u0007[\u0012I'!A\u0005\n\r=\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u001d\u0011\t\u0005]81O\u0005\u0005\u0007k\nIP\u0001\u0004PE*,7\r\u001e")
public class CalendarDate
implements Ordered<CalendarDate>,
Serializable {
    private final CalendarYearMonth yearMonth;
    private final DayOfMonth day;
    private final ZoneId zoneId;
    private LocalDate asLocalDate;
    private CalendarInterval asYearInterval;
    private final DayOfMonth breachEncapsulationOfDay;
    private final CalendarYearMonth breachEncapsulationOfYearMonth;
    private DayOfWeek dayOfWeek;
    private CalendarDate nextDay;
    private CalendarDate previousDay;
    @SuppressWarnings(value={"deprecation"})
    private Calendar asJavaCalendarOnMidnight;
    private ZonedDateTime asJavaZonedDateTimeOnMidnight;
    private volatile byte bitmap$0;

    public static ZoneId from$default$2() {
        return CalendarDate$.MODULE$.from$default$2();
    }

    public static CalendarDate parse(String string, String string2) {
        return CalendarDate$.MODULE$.parse(string, string2);
    }

    public static CalendarDate parse(String string, String string2, ZoneId zoneId) {
        return CalendarDate$.MODULE$.parse(string, string2, zoneId);
    }

    public static CalendarDate parse(String string, String string2, TimeZone timeZone) {
        return CalendarDate$.MODULE$.parse(string, string2, timeZone);
    }

    public static CalendarDate from(LocalDate localDate, ZoneId zoneId) {
        return CalendarDate$.MODULE$.from(localDate, zoneId);
    }

    public static CalendarDate from(TimePoint timePoint, ZoneId zoneId) {
        return CalendarDate$.MODULE$.from(timePoint, zoneId);
    }

    public static CalendarDate from(TimePoint timePoint, TimeZone timeZone) {
        return CalendarDate$.MODULE$.from(timePoint, timeZone);
    }

    public static CalendarDate from(TimePoint timePoint) {
        return CalendarDate$.MODULE$.from(timePoint);
    }

    public static CalendarDate from(int n, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, ZoneId zoneId) {
        return CalendarDate$.MODULE$.from(n, monthOfYear, dayOfMonth, zoneId);
    }

    public static CalendarDate from(int n, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, TimeZone timeZone) {
        return CalendarDate$.MODULE$.from(n, monthOfYear, dayOfMonth, timeZone);
    }

    public static CalendarDate from(int n, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
        return CalendarDate$.MODULE$.from(n, monthOfYear, dayOfMonth);
    }

    public static CalendarDate from(int n, int n2, int n3, ZoneId zoneId) {
        return CalendarDate$.MODULE$.from(n, n2, n3, zoneId);
    }

    public static CalendarDate from(int n, int n2, int n3, TimeZone timeZone) {
        return CalendarDate$.MODULE$.from(n, n2, n3, timeZone);
    }

    public static CalendarDate from(int n, int n2, int n3) {
        return CalendarDate$.MODULE$.from(n, n2, n3);
    }

    public static CalendarDate from(CalendarYearMonth calendarYearMonth, DayOfMonth dayOfMonth, ZoneId zoneId) {
        return CalendarDate$.MODULE$.from(calendarYearMonth, dayOfMonth, zoneId);
    }

    public static CalendarDate from(CalendarYearMonth calendarYearMonth, DayOfMonth dayOfMonth, TimeZone timeZone) {
        return CalendarDate$.MODULE$.from(calendarYearMonth, dayOfMonth, timeZone);
    }

    public static CalendarDate from(CalendarYearMonth calendarYearMonth, DayOfMonth dayOfMonth) {
        return CalendarDate$.MODULE$.from(calendarYearMonth, dayOfMonth);
    }

    public static Option<Tuple3<CalendarYearMonth, DayOfMonth, TimeZone>> unapply(CalendarDate calendarDate) {
        return CalendarDate$.MODULE$.unapply(calendarDate);
    }

    public static CalendarDate apply(CalendarYearMonth calendarYearMonth, DayOfMonth dayOfMonth) {
        return CalendarDate$.MODULE$.apply(calendarYearMonth, dayOfMonth);
    }

    private LocalDate asLocalDate$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.asLocalDate = LocalDate.of(this.yearMonth().year(), this.yearMonth().month().value(), this.day().value());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.asLocalDate;
        }
    }

    private CalendarInterval asYearInterval$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.asYearInterval = CalendarInterval$.MODULE$.year(this.yearMonth().year(), this.zoneId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.asYearInterval;
        }
    }

    private DayOfWeek dayOfWeek$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                ZonedDateTime zonedDateTime = this.asJavaZonedDateTimeOnMidnight(this.zoneId());
                this.dayOfWeek = DayOfWeek$.MODULE$.apply(zonedDateTime.getDayOfWeek());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.dayOfWeek;
        }
    }

    private CalendarDate nextDay$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.nextDay = this.plusDays(1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.nextDay;
        }
    }

    private CalendarDate previousDay$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.previousDay = this.plusDays(-1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.previousDay;
        }
    }

    private Calendar asJavaCalendarOnMidnight$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.asJavaCalendarOnMidnight = this.asJavaCalendarOnMidnight(TimeZone.getTimeZone(this.zoneId()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.asJavaCalendarOnMidnight;
        }
    }

    private ZonedDateTime asJavaZonedDateTimeOnMidnight$lzycompute() {
        CalendarDate calendarDate = this;
        synchronized (calendarDate) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.asJavaZonedDateTimeOnMidnight = this.asJavaZonedDateTimeOnMidnight(ZoneIds$.MODULE$.Default());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.asJavaZonedDateTimeOnMidnight;
        }
    }

    public boolean $less(Object that) {
        return Ordered.class.$less((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.class.$greater((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.class.$less$eq((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.class.$greater$eq((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.class.compareTo((Ordered)this, (Object)that);
    }

    public CalendarYearMonth yearMonth() {
        return this.yearMonth;
    }

    public DayOfMonth day() {
        return this.day;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public LocalDate asLocalDate() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.asLocalDate$lzycompute() : this.asLocalDate;
    }

    public int compare(CalendarDate other) {
        return this.isBefore(other) ? -1 : (this.isAfter(other) ? 1 : 0);
    }

    public CalendarYearMonth asCalendarMonth() {
        return this.yearMonth();
    }

    public CalendarInterval asMonthInterval() {
        return CalendarInterval$.MODULE$.month(this.yearMonth());
    }

    public TimeInterval asTimeInterval(TimeZone timeZone) {
        return TimeInterval$.MODULE$.startingFrom(new Limit<TimePoint>(this.startAsTimePoint(timeZone.toZoneId()), (Function1<TimePoint, Ordered<TimePoint>>)Predef$.MODULE$.conforms()), true, Duration$.MODULE$.days(1), false);
    }

    public TimeInterval asTimeInterval(ZoneId zoneId) {
        return TimeInterval$.MODULE$.startingFrom(new Limit<TimePoint>(this.startAsTimePoint(zoneId), (Function1<TimePoint, Ordered<TimePoint>>)Predef$.MODULE$.conforms()), true, Duration$.MODULE$.days(1), false);
    }

    public ZoneId asTimeInterval$default$1() {
        return this.zoneId();
    }

    public CalendarInterval asYearInterval() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.asYearInterval$lzycompute() : this.asYearInterval;
    }

    public CalendarDateTime atCalendarDateTime(TimeOfDay timeOfDay) {
        return CalendarDateTime$.MODULE$.from(this, timeOfDay);
    }

    public DayOfMonth breachEncapsulationOfDay() {
        return this.breachEncapsulationOfDay;
    }

    public CalendarYearMonth breachEncapsulationOfYearMonth() {
        return this.breachEncapsulationOfYearMonth;
    }

    public DayOfWeek dayOfWeek() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dayOfWeek$lzycompute() : this.dayOfWeek;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof CalendarDate) {
            CalendarDate calendarDate = (CalendarDate)object;
            DayOfMonth dayOfMonth = this.day();
            DayOfMonth dayOfMonth2 = calendarDate.day();
            if (dayOfMonth == null) {
                if (dayOfMonth2 != null) {
                    return false;
                }
            } else if (!((Object)dayOfMonth).equals(dayOfMonth2)) return false;
            CalendarYearMonth calendarYearMonth = this.yearMonth();
            CalendarYearMonth calendarYearMonth2 = calendarDate.yearMonth();
            if (calendarYearMonth == null) {
                if (calendarYearMonth2 == null) return true;
                return false;
            } else {
                if (!((Object)calendarYearMonth).equals(calendarYearMonth2)) return false;
                return true;
            }
        }
        if (!(object instanceof CalendarDateTime)) return false;
        CalendarDateTime calendarDateTime = (CalendarDateTime)object;
        CalendarDate calendarDate = this;
        CalendarDate calendarDate2 = calendarDateTime.date();
        if (calendarDate != null) {
            if (!((Object)calendarDate).equals(calendarDate2)) return false;
            return true;
        }
        if (calendarDate2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 * (this.day().hashCode() + this.yearMonth().hashCode());
    }

    public boolean isAfter(CalendarDate other) {
        return !this.isBefore(other) && !this.equals(other);
    }

    public boolean isBefore(CalendarDate other) {
        return this.yearMonth().isBefore(other.yearMonth()) ? true : (this.yearMonth().isAfter(other.yearMonth()) ? false : this.day().isBefore(other.day()));
    }

    public CalendarDate plus(Duration length) {
        return length.addedTo(this, this.zoneId());
    }

    public CalendarDate minus(Duration length) {
        return length.subtractedFrom(this, this.zoneId());
    }

    public CalendarDate plusDays(int increment) {
        ZonedDateTime zonedDateTime = this.asJavaZonedDateTimeOnMidnight();
        ZonedDateTime newZonedDateTime = zonedDateTime.plusDays(increment);
        int year = newZonedDateTime.getYear();
        int month = newZonedDateTime.getMonthValue();
        int day = newZonedDateTime.getDayOfMonth();
        return CalendarDate$.MODULE$.from(year, month, day, zonedDateTime.getZone());
    }

    public CalendarDate minusDays(int decrement) {
        ZonedDateTime zonedDateTime = this.asJavaZonedDateTimeOnMidnight();
        ZonedDateTime newZonedDateTime = zonedDateTime.minusDays(decrement);
        int year = newZonedDateTime.getYear();
        int month = newZonedDateTime.getMonthValue();
        int day = newZonedDateTime.getDayOfMonth();
        return CalendarDate$.MODULE$.from(year, month, day, zonedDateTime.getZone());
    }

    public CalendarDate plusMonths(int increment) {
        ZonedDateTime zonedDateTime = this.asJavaZonedDateTimeOnMidnight();
        ZonedDateTime newZonedDateTime = zonedDateTime.plusMonths(increment);
        int year = newZonedDateTime.getYear();
        int month = newZonedDateTime.getMonthValue();
        int day = newZonedDateTime.getDayOfMonth();
        return CalendarDate$.MODULE$.from(year, month, day, zonedDateTime.getZone());
    }

    public CalendarDate minusMonths(int decrement) {
        ZonedDateTime zonedDateTime = this.asJavaZonedDateTimeOnMidnight();
        ZonedDateTime newZonedDateTime = zonedDateTime.minusMonths(decrement);
        int year = newZonedDateTime.getYear();
        int month = newZonedDateTime.getMonthValue();
        int day = newZonedDateTime.getDayOfMonth();
        return CalendarDate$.MODULE$.from(year, month, day, zonedDateTime.getZone());
    }

    public CalendarDate nextDay() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.nextDay$lzycompute() : this.nextDay;
    }

    public CalendarDate previousDay() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.previousDay$lzycompute() : this.previousDay;
    }

    public TimePoint startAsTimePoint(TimeZone timeZone) {
        return TimePoint$.MODULE$.atMidnight(this, timeZone.toZoneId());
    }

    public TimePoint startAsTimePoint(ZoneId zoneId) {
        return TimePoint$.MODULE$.atMidnight(this, zoneId);
    }

    public ZoneId startAsTimePoint$default$1() {
        return ZoneIds$.MODULE$.Default();
    }

    public CalendarInterval through(CalendarDate otherDate) {
        return CalendarInterval$.MODULE$.inclusive(new Limit<CalendarDate>(this, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(otherDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public String toString() {
        return this.toString("yyyy/MM/dd");
    }

    @SuppressWarnings(value={"deprecation"})
    public String toString(String pattern) {
        TimePoint point = this.startAsTimePoint(this.zoneId());
        return point.toString(pattern, this.zoneId());
    }

    public Calendar asJavaCalendarOnMidnight() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.asJavaCalendarOnMidnight$lzycompute() : this.asJavaCalendarOnMidnight;
    }

    /*
     * WARNING - void declaration
     */
    public Calendar asJavaCalendarOnMidnight(TimeZone timeZone) {
        void var2_2;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(1, this.yearMonth().year());
        calendar.set(2, this.yearMonth().month().calendarValue());
        calendar.set(5, this.day().value());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return var2_2;
    }

    public ZonedDateTime asJavaZonedDateTimeOnMidnight() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.asJavaZonedDateTimeOnMidnight$lzycompute() : this.asJavaZonedDateTimeOnMidnight;
    }

    public ZonedDateTime asJavaZonedDateTimeOnMidnight(ZoneId zoneId) {
        return ZonedDateTime.of(this.yearMonth().year(), this.yearMonth().month().value(), this.day().value(), 0, 0, 0, 0, zoneId);
    }

    public CalendarDate(CalendarYearMonth yearMonth, DayOfMonth day, ZoneId zoneId) {
        this.yearMonth = yearMonth;
        this.day = day;
        this.zoneId = zoneId;
        Ordered.class.$init$((Ordered)this);
        this.breachEncapsulationOfDay = day;
        this.breachEncapsulationOfYearMonth = yearMonth;
    }
}

