/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.time.ZoneId;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.intervals.Limit;
import org.sisioh.baseunits.scala.intervals.LimitValue;
import org.sisioh.baseunits.scala.intervals.Limitless;
import org.sisioh.baseunits.scala.time.CalendarDate;
import org.sisioh.baseunits.scala.time.CalendarDate$;
import org.sisioh.baseunits.scala.time.CalendarInterval;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.DayOfMonth$;
import org.sisioh.baseunits.scala.time.Duration;
import org.sisioh.baseunits.scala.time.MonthOfYear;
import org.sisioh.baseunits.scala.time.MonthOfYear$;
import org.sisioh.baseunits.scala.time.TimeUnit$;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordered;

public final class CalendarInterval$
implements Serializable {
    public static final CalendarInterval$ MODULE$;

    static {
        new CalendarInterval$();
    }

    public CalendarInterval apply(LimitValue<CalendarDate> startValue, LimitValue<CalendarDate> endValue) {
        return new CalendarInterval(startValue, endValue);
    }

    public Option<Tuple2<LimitValue<CalendarDate>, LimitValue<CalendarDate>>> unapply(CalendarInterval calendarInterval) {
        return new Some((Object)new Tuple2(calendarInterval.start(), calendarInterval.end()));
    }

    public CalendarInterval everFrom(LimitValue<CalendarDate> startDate) {
        return this.inclusive(startDate, new Limitless<CalendarDate>((Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval everPreceding(LimitValue<CalendarDate> endDate) {
        return this.inclusive(new Limitless<CalendarDate>((Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), endDate);
    }

    public CalendarInterval inclusive(LimitValue<CalendarDate> start, LimitValue<CalendarDate> end) {
        return new CalendarInterval(start, end);
    }

    public CalendarInterval inclusive(int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay, TimeZone timeZone) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(startYear, startMonth, startDay, timeZone);
        CalendarDate endDate = CalendarDate$.MODULE$.from(endYear, endMonth, endDay, timeZone);
        return new CalendarInterval(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval inclusive(int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay, ZoneId zoneId) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(startYear, startMonth, startDay, zoneId);
        CalendarDate endDate = CalendarDate$.MODULE$.from(endYear, endMonth, endDay, zoneId);
        return new CalendarInterval(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval inclusive(int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay) {
        return this.inclusive(startYear, startMonth, startDay, endYear, endMonth, endDay, ZoneIds$.MODULE$.Default());
    }

    public CalendarInterval month(CalendarYearMonth month) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(month, DayOfMonth$.MODULE$.apply(1), month.zoneId());
        CalendarDate endMonth = startDate.plusMonths(1);
        CalendarDate endDate = endMonth.plusDays(-1);
        return this.inclusive(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval month(int year, int month, TimeZone timeZone) {
        return this.month(year, MonthOfYear$.MODULE$.apply(month), timeZone.toZoneId());
    }

    public CalendarInterval month(int year, int month, ZoneId zoneId) {
        return this.month(year, MonthOfYear$.MODULE$.apply(month), zoneId);
    }

    public CalendarInterval month(int year, int month) {
        return this.month(year, MonthOfYear$.MODULE$.apply(month), ZoneIds$.MODULE$.Default());
    }

    public CalendarInterval month(int year, MonthOfYear month, TimeZone timeZone) {
        return this.month(year, month, timeZone.toZoneId());
    }

    public CalendarInterval month(int year, MonthOfYear month, ZoneId zoneId) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(year, month, DayOfMonth$.MODULE$.apply(1), zoneId);
        CalendarDate endDate = startDate.plusMonths(1).plusDays(-1);
        return this.inclusive(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval month(int year, MonthOfYear month) {
        return this.month(year, month, ZoneIds$.MODULE$.Default());
    }

    public CalendarInterval startingFrom(LimitValue<CalendarDate> start, Duration length) {
        return length.unit().compareTo(TimeUnit$.MODULE$.Day()) < 0 ? this.inclusive(start, start) : this.inclusive(start, new Limit<CalendarDate>(start.toValue().plus(length).plusDays(-1), (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval year(int year, TimeZone timeZone) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(year, 1, 1, timeZone);
        CalendarDate endDate = CalendarDate$.MODULE$.from(year + 1, 1, 1, timeZone).plusDays(-1);
        return this.inclusive(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    public CalendarInterval year(int year, ZoneId zoneId) {
        CalendarDate startDate = CalendarDate$.MODULE$.from(year, 1, 1, zoneId);
        CalendarDate endDate = CalendarDate$.MODULE$.from(year + 1, 1, 1, zoneId).plusDays(-1);
        return this.inclusive(new Limit<CalendarDate>(startDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()), new Limit<CalendarDate>(endDate, (Function1<CalendarDate, Ordered<CalendarDate>>)Predef$.MODULE$.conforms()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CalendarInterval$() {
        MODULE$ = this;
    }
}

