/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.MonthOfYear;
import org.sisioh.baseunits.scala.time.MonthOfYear$;
import org.sisioh.baseunits.scala.time.TimePoint;
import org.sisioh.baseunits.scala.time.TimePoint$;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class CalendarYearMonth$
implements Serializable {
    public static final CalendarYearMonth$ MODULE$;

    static {
        new CalendarYearMonth$();
    }

    public CalendarYearMonth apply(int year, int month, TimeZone timeZone) {
        return this.from(year, month, timeZone.toZoneId());
    }

    public CalendarYearMonth apply(int year, int month, ZoneId zoneId) {
        return this.from(year, month, zoneId);
    }

    public ZoneId apply$default$3() {
        return ZoneIds$.MODULE$.Default();
    }

    public CalendarYearMonth from(int year, int month, TimeZone timeZone) {
        return new CalendarYearMonth(year, MonthOfYear$.MODULE$.apply(month), timeZone.toZoneId());
    }

    public CalendarYearMonth from(int year, int month, ZoneId zoneId) {
        return new CalendarYearMonth(year, MonthOfYear$.MODULE$.apply(month), zoneId);
    }

    public Option<Tuple2<Object, MonthOfYear>> unapply(CalendarYearMonth calendarMonth) {
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)calendarMonth.year()), (Object)calendarMonth.month()));
    }

    public CalendarYearMonth from(int year, int month) {
        return this.from(year, month, ZoneIds$.MODULE$.Default());
    }

    public CalendarYearMonth from(int year, MonthOfYear month) {
        return this.from(year, month, ZoneIds$.MODULE$.Default());
    }

    public CalendarYearMonth from(int year, MonthOfYear month, TimeZone timeZone) {
        return new CalendarYearMonth(year, month, timeZone.toZoneId());
    }

    public CalendarYearMonth from(int year, MonthOfYear month, ZoneId zoneId) {
        return new CalendarYearMonth(year, month, zoneId);
    }

    public CalendarYearMonth parse(String dateString, String pattern, TimeZone timeZone) {
        TimePoint point = TimePoint$.MODULE$.parse(dateString, pattern, timeZone);
        return this.from(point, timeZone.toZoneId());
    }

    public CalendarYearMonth parse(String dateString, String pattern, ZoneId zoneId) {
        TimePoint point = TimePoint$.MODULE$.parse(dateString, pattern, zoneId);
        return this.from(point, zoneId);
    }

    public ZoneId parse$default$3() {
        return ZoneIds$.MODULE$.Default();
    }

    public CalendarYearMonth from(TimePoint timePoint, TimeZone timeZone) {
        return this.from(timePoint, timeZone.toZoneId());
    }

    public CalendarYearMonth from(TimePoint timePoint, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = timePoint.asJavaZonedDateTime(zoneId);
        return this.from(zonedDateTime);
    }

    public CalendarYearMonth from(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        return this.from(year, month, calendar.getTimeZone());
    }

    public CalendarYearMonth from(ZonedDateTime zonedDateTime) {
        int year = zonedDateTime.getYear();
        int month = zonedDateTime.getMonthValue();
        return this.from(year, month, zonedDateTime.getZone());
    }

    public ZoneId from$default$2() {
        return ZoneIds$.MODULE$.Default();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CalendarYearMonth$() {
        MODULE$ = this;
    }
}

