/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.intervals.Limit;
import org.sisioh.baseunits.scala.intervals.LimitValue;
import org.sisioh.baseunits.scala.time.CalendarDate;
import org.sisioh.baseunits.scala.time.CalendarDate$;
import org.sisioh.baseunits.scala.time.CalendarInterval;
import org.sisioh.baseunits.scala.time.CalendarInterval$;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.CalendarYearMonth$;
import org.sisioh.baseunits.scala.time.Duration$;
import org.sisioh.baseunits.scala.time.TimeInterval;
import org.sisioh.baseunits.scala.time.TimeInterval$;
import org.sisioh.baseunits.scala.time.TimePoint;
import org.sisioh.baseunits.scala.time.TimePoint$;
import org.sisioh.baseunits.scala.time.TimeUnit;
import org.sisioh.baseunits.scala.time.TimeUnit$;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import org.sisioh.baseunits.scala.util.Ratio;
import org.sisioh.baseunits.scala.util.Ratio$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001B\u0001\u0003\u00015\u0011\u0001\u0002R;sCRLwN\u001c\u0006\u0003\u0007\u0011\tA\u0001^5nK*\u0011QAB\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000f!\t\u0011BY1tKVt\u0017\u000e^:\u000b\u0005%Q\u0011AB:jg&|\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001abE\u0011\u0011\u0005=\tR\"\u0001\t\u000b\u0003\u0015I!A\u0005\t\u0003\r\u0005s\u0017PU3g!\r!Bd\b\b\u0003+iq!AF\r\u000e\u0003]Q!\u0001\u0007\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u000e\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\b\u0010\u0003\u000f=\u0013H-\u001a:fI*\u00111\u0004\u0005\t\u0003A\u0001i\u0011A\u0001\t\u0003\u001f\tJ!a\t\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0001\"];b]RLG/_\u000b\u0002OA\u0011q\u0002K\u0005\u0003SA\u0011A\u0001T8oO\"A1\u0006\u0001B\u0001B\u0003%q%A\u0005rk\u0006tG/\u001b;zA!AQ\u0006\u0001BC\u0002\u0013\u0005a&\u0001\u0003v]&$X#A\u0018\u0011\u0005\u0001\u0002\u0014BA\u0019\u0003\u0005!!\u0016.\\3V]&$\b\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u000bUt\u0017\u000e\u001e\u0011\t\rU\u0002A\u0011\u0001\u00027\u0003\u0019a\u0014N\\5u}Q\u0019qd\u000e\u001d\t\u000b\u0015\"\u0004\u0019A\u0014\t\u000b5\"\u0004\u0019A\u0018\t\u000bi\u0002A\u0011A\u001e\u0002\u000f\u0005$G-\u001a3U_R\u0011Ah\u0010\t\u0003AuJ!A\u0010\u0002\u0003\u0019\r\u000bG.\u001a8eCJ$\u0015\r^3\t\u000b\u0001K\u0004\u0019\u0001\u001f\u0002\u0007\u0011\f\u0017\u0010C\u0003;\u0001\u0011\u0005!\tF\u0002=\u0007\u0012CQ\u0001Q!A\u0002qBQ!R!A\u0002\u0019\u000b\u0001\u0002^5nKj{g.\u001a\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA!\u001e;jY*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005!!\u0016.\\3[_:,\u0007\u0006B!P%R\u0003\"a\u0004)\n\u0005E\u0003\"A\u00033faJ,7-\u0019;fI\u0006\n1+A\u001fVg\u0016\u0004\u0013\r\u001a3fIR{\u0007\u0006Z1zu\u0001\u001a\u0015\r\\3oI\u0006\u0014H)\u0019;fY\u0001RxN\\3JIj\u0002#l\u001c8f\u0013\u0012L\u0003%\\3uQ>$\u0007%\u001b8ti\u0016\fG-I\u0001V\u0003\u0019\u0001d&\r\u00182q!)!\b\u0001C\u0001/R\u0019A\bW-\t\u000b\u00013\u0006\u0019\u0001\u001f\t\u000bi3\u0006\u0019A.\u0002\ri|g.Z%e!\taf,D\u0001^\u0015\t\u0019!*\u0003\u0002`;\n1!l\u001c8f\u0013\u0012DQA\u000f\u0001\u0005\u0002\u0005$2AY3h!\t\u00013-\u0003\u0002e\u0005\t\t2)\u00197f]\u0012\f'/W3be6{g\u000e\u001e5\t\u000b\u0019\u0004\u0007\u0019\u00012\u0002\u000b5|g\u000e\u001e5\t\u000b\u0015\u0003\u0007\u0019\u0001$)\t\u0001|\u0015\u000eV\u0011\u0002U\u0006!Uk]3!C\u0012$W\r\u001a+pQ5|g\u000e\u001e5;A\r\u000bG.\u001a8eCJLV-\u0019:N_:$\b\u000e\f\u0011{_:,\u0017\n\u001a\u001e!5>tW-\u00133*A5,G\u000f[8eA%t7\u000f^3bI\")!\b\u0001C\u0001YR\u0019!-\u001c8\t\u000b\u0019\\\u0007\u0019\u00012\t\u000fi[\u0007\u0013!a\u00017\")!\b\u0001C\u0001aR\u0011\u0011\u000f\u001e\t\u0003AIL!a\u001d\u0002\u0003\u0013QKW.\u001a)pS:$\b\"B;p\u0001\u0004\t\u0018!\u00029pS:$\bbB<\u0001\u0005\u0004%\tAJ\u0001\u001eEJ,\u0017m\u00195F]\u000e\f\u0007o];mCRLwN\\(g#V\fg\u000e^5us\"\"aoT=UC\u0005Q\u0018!H+tK\u0002\nX/\u00198uSRL\b\u0005\u001d:pa\u0016\u0014H/\u001f\u0011j]N$X-\u00193\t\rq\u0004\u0001\u0015!\u0003(\u0003y\u0011'/Z1dQ\u0016s7-\u00199tk2\fG/[8o\u001f\u001a\fV/\u00198uSRL\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011\u0001\u0018\u00023\t\u0014X-Y2i\u000b:\u001c\u0017\r]:vY\u0006$\u0018n\u001c8PMVs\u0017\u000e\u001e\u0015\u0006{>\u000b\t\u0001V\u0011\u0003\u0003\u0007\t\u0011$V:fAUt\u0017\u000e\u001e\u0011qe>\u0004XM\u001d;zA%t7\u000f^3bI\"9\u0011q\u0001\u0001!\u0002\u0013y\u0013A\u00072sK\u0006\u001c\u0007.\u00128dCB\u001cX\u000f\\1uS>twJZ+oSR\u0004\u0003bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\bG>l\u0007/\u0019:f)\u0011\ty!!\u0006\u0011\u0007=\t\t\"C\u0002\u0002\u0014A\u00111!\u00138u\u0011\u001d\t9\"!\u0003A\u0002}\tQa\u001c;iKJDq!a\u0007\u0001\t\u0003\ti\"A\u0005eSZLG-\u001a3CsR!\u0011qDA\u0015!\u0011\t\t#!\n\u000e\u0005\u0005\r\"BA%\u0005\u0013\u0011\t9#a\t\u0003\u000bI\u000bG/[8\t\u000f\u0005-\u0012\u0011\u0004a\u0001?\u00059A-\u001b<jg>\u0014\bbBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0012\u0011\b\t\u0004\u001f\u0005U\u0012bAA\u001c!\t9!i\\8mK\u0006t\u0007\u0002CA\u001e\u0003[\u0001\r!!\u0010\u0002\u0007=\u0014'\u000eE\u0002\u0010\u0003\u007fI1!!\u0011\u0011\u0005\r\te.\u001f\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003!A\u0017m\u001d5D_\u0012,GCAA\b\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\nQ!\\5okN$2aHA(\u0011\u001d\t9\"!\u0013A\u0002}A\u0011\"a\u0015\u0001\u0011\u000b\u0007I\u0011\u0001\u0018\u0002\u001d9|'/\\1mSj,G-\u00168ji\"I\u0011q\u000b\u0001\t\u0002\u0003\u0006KaL\u0001\u0010]>\u0014X.\u00197ju\u0016$WK\\5uA!9\u00111\f\u0001\u0005\u0002\u0005u\u0013\u0001\u00029mkN$2aHA0\u0011\u001d\t9\"!\u0017A\u0002}Aq!a\u0019\u0001\t\u0003\t)'A\u0005qe\u0016\u001cW\rZ5oOR!\u0011qMA7!\r\u0001\u0013\u0011N\u0005\u0004\u0003W\u0012!\u0001\u0004+j[\u0016Le\u000e^3sm\u0006d\u0007\u0002CA8\u0003C\u0002\r!!\u001d\u0002\u0007\u0015tG\rE\u0003\u0002t\u0005e\u0014/\u0004\u0002\u0002v)\u0019\u0011q\u000f\u0003\u0002\u0013%tG/\u001a:wC2\u001c\u0018\u0002BA>\u0003k\u0012!\u0002T5nSR4\u0016\r\\;f\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003\u000b\u0001d\u001d;beRLgn\u001a$s_6\u001c\u0015\r\\3oI\u0006\u0014H)\u0019;f)\u0011\t\u0019)!#\u0011\u0007\u0001\n))C\u0002\u0002\b\n\u0011\u0001cQ1mK:$\u0017M]%oi\u0016\u0014h/\u00197\t\u0011\u0005-\u0015Q\u0010a\u0001\u0003\u001b\u000bQa\u001d;beR\u0004R!a\u001d\u0002zqBq!!%\u0001\t\u0003\t\u0019*A\u000bti\u0006\u0014H/\u001b8h\rJ|W\u000eV5nKB{\u0017N\u001c;\u0015\t\u0005\u001d\u0014Q\u0013\u0005\t\u0003\u0017\u000by\t1\u0001\u0002r!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0015AD:vER\u0014\u0018m\u0019;fI\u001a\u0013x.\u001c\u000b\u0006y\u0005u\u0015q\u0014\u0005\u0007\u0001\u0006]\u0005\u0019\u0001\u001f\t\r\u0015\u000b9\n1\u0001GQ\u0019\t9jTAR)\u0006\u0012\u0011QU\u0001E+N,\u0007e];ciJ\f7\r^3e\rJ|W\u000e\u000b3bsj\u00023)\u00197f]\u0012\f'\u000fR1uK2\u0002#p\u001c8f\u0013\u0012T\u0004EW8oK&#\u0017\u0006I7fi\"|G\rI5ogR,\u0017\r\u001a\u0005\b\u00033\u0003A\u0011AAU)\u0015a\u00141VAW\u0011\u0019\u0001\u0015q\u0015a\u0001y!1!,a*A\u0002mCq!!'\u0001\t\u0003\t\t\fF\u0002r\u0003gCa!^AX\u0001\u0004\t\bBCA\\\u0001!\u0015\r\u0011\"\u0001\u0002:\u0006\u0011Bo\u001c(pe6\fG.\u001b>fIN#(/\u001b8h+\t\tY\f\u0005\u0003\u0002>\u0006\rgbA\b\u0002@&\u0019\u0011\u0011\u0019\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t)-a2\u0003\rM#(/\u001b8h\u0015\r\t\t\r\u0005\u0005\u000b\u0003\u0017\u0004\u0001\u0012!Q!\n\u0005m\u0016a\u0005;p\u001d>\u0014X.\u00197ju\u0016$7\u000b\u001e:j]\u001e\u0004\u0003bBAh\u0001\u0011\u0005\u0013\u0011[\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0018\u0005\t\u0003+\u0004A\u0011\u0001\u0002\u0002X\u0006\u0019\u0012\r\u001a3B[>,h\u000e\u001e+p\u0007\u0006dWM\u001c3beR1\u0011\u0011\\Ap\u0003G\u00042aDAn\u0013\r\ti\u000e\u0005\u0002\u0005+:LG\u000fC\u0004\u0002b\u0006M\u0007\u0019A\u0014\u0002\r\u0005lw.\u001e8u\u0011!\t)/a5A\u0002\u0005\u001d\u0018\u0001C2bY\u0016tG-\u0019:\u0011\u0007\u001d\u000bI/C\u0002\u0002l\"\u0013\u0001bQ1mK:$\u0017M\u001d\u0005\t\u0003_\u0004A\u0011\u0001\u0002\u0002r\u0006A\u0012\r\u001a3B[>,h\u000e\u001e+p5>tW\r\u001a#bi\u0016$\u0016.\\3\u0015\r\u0005M\u0018\u0011`A~!\ra\u0016Q_\u0005\u0004\u0003ol&!\u0004.p]\u0016$G)\u0019;f)&lW\rC\u0004\u0002b\u00065\b\u0019A\u0014\t\u0011\u0005u\u0018Q\u001ea\u0001\u0003g\fQB_8oK\u0012$\u0015\r^3US6,\u0007\u0002\u0003B\u0001\u0001\u0011\u0005!Aa\u0001\u0002)\u0005$G-Q7pk:$Hk\u001c+j[\u0016\u0004v.\u001b8u)\u001d\t(Q\u0001B\u0004\u0005\u0013Aq!!9\u0002\u0000\u0002\u0007q\u0005\u0003\u0004v\u0003\u007f\u0004\r!\u001d\u0005\u0007\u000b\u0006}\b\u0019\u0001$)\r\u0005}xJ!\u0004UC\t\u0011y!A$Vg\u0016\u0004\u0013\r\u001a3B[>,h\u000e\u001e+p)&lW\rU8j]RD\u0013-\\8v]RT\u0004\u0005T8oO2\u0002\u0003o\\5oij\u0002C+[7f!>Lg\u000e^\u0015![\u0016$\bn\u001c3!S:\u001cH/Z1e\u0011!\u0011\t\u0001\u0001C\u0001\u0005\tMA#B9\u0003\u0016\t]\u0001bBAq\u0005#\u0001\ra\n\u0005\u0007k\nE\u0001\u0019A9\t\u0013\tm\u0001\u0001#b\u0001\n\u00031\u0013aC5o\u0005\u0006\u001cX-\u00168jiND\u0011Ba\b\u0001\u0011\u0003\u0005\u000b\u0015B\u0014\u0002\u0019%t')Y:f+:LGo\u001d\u0011\t\u0011\t\r\u0002\u0001\"\u0001\u0003\u0005K\t!d];ciJ\f7\r^!n_VtGO\u0012:p[\u000e\u000bG.\u001a8eCJ$b!!7\u0003(\t%\u0002bBAq\u0005C\u0001\ra\n\u0005\t\u0003K\u0014\t\u00031\u0001\u0002h\"A!Q\u0006\u0001\u0005\u0002\t\u0011y#A\u0010tk\n$(/Y2u\u00036|WO\u001c;Ge>l'l\u001c8fI\u0012\u000bG/\u001a+j[\u0016$b!a=\u00032\tM\u0002bBAq\u0005W\u0001\ra\n\u0005\t\u0003{\u0014Y\u00031\u0001\u0002t\"9!q\u0007\u0001\u0005\n\te\u0012\u0001E2iK\u000e\\\u0017)\\8v]R4\u0016\r\\5e)\u0011\tINa\u000f\t\u000f\u0005\u0005(Q\u0007a\u0001O!9!q\b\u0001\u0005\n\t\u0005\u0013\u0001E2iK\u000e\\7i\u001c8wKJ$\u0018N\u00197f)\u0011\tINa\u0011\t\u000f\u0005]!Q\ba\u0001?!9!q\t\u0001\u0005\n\t%\u0013!G2iK\u000e\\wI]3bi\u0016\u0014H\u000b[1o\u001fJ,\u0015/^1m)>$B!!7\u0003L!9\u0011q\u0003B#\u0001\u0004y\u0002b\u0002B(\u0001\u0011%!\u0011K\u0001\u0010SN\u001cuN\u001c<feRL'\r\\3U_R!\u00111\u0007B*\u0011\u001d\t9B!\u0014A\u0002}Aq!a.\u0001\t\u0013\u00119\u0006\u0006\u0003\u0002<\ne\u0003\u0002\u0003B.\u0005+\u0002\rA!\u0018\u0002\u000bUt\u0017\u000e^:\u0011\tQ\u0011yfL\u0005\u0004\u0005Cr\"aA*fc\"I!Q\r\u0001\u0012\u0002\u0013\u0005!qM\u0001\u0012C\u0012$W\r\u001a+pI\u0011,g-Y;mi\u0012\u0012TC\u0001B5U\rY&1N\u0016\u0003\u0005[\u0002BAa\u001c\u0003z5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(A\u0005v]\u000eDWmY6fI*\u0019!q\u000f\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003|\tE$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001e9!q\u0010\u0002\t\u0002\t\u0005\u0015\u0001\u0003#ve\u0006$\u0018n\u001c8\u0011\u0007\u0001\u0012\u0019I\u0002\u0004\u0002\u0005!\u0005!QQ\n\u0005\u0005\u0007s\u0011\u0005C\u00046\u0005\u0007#\tA!#\u0015\u0005\t\u0005\u0005B\u0003BG\u0005\u0007\u0013\r\u0011\"\u0001\u0003\u0010\u0006!aj\u001c8f+\u0005y\u0002\u0002\u0003BJ\u0005\u0007\u0003\u000b\u0011B\u0010\u0002\u000b9{g.\u001a\u0011\t\u0011\t]%1\u0011C\u0001\u00053\u000bA\u0001Z1zgR\u0019qDa'\t\u0011\tu%Q\u0013a\u0001\u0003\u001f\tq\u0001[8x\u001b\u0006t\u0017\u0010\u0003\u0005\u0003\"\n\rE\u0011\u0001BR\u0003\r\"\u0017-_:I_V\u00148/T5okR,7oU3d_:$7/T5mY&\u001cXmY8oIN$2b\bBS\u0005O\u0013YKa,\u00034\"A!q\u0013BP\u0001\u0004\ty\u0001\u0003\u0005\u0003*\n}\u0005\u0019AA\b\u0003\u0015Aw.\u001e:t\u0011!\u0011iKa(A\u0002\u0005=\u0011aB7j]V$Xm\u001d\u0005\t\u0005c\u0013y\n1\u0001\u0002\u0010\u000591/Z2p]\u0012\u001c\bb\u0002B[\u0005?\u0003\raJ\u0001\r[&dG.[:fG>tGm\u001d\u0005\t\u0005S\u0013\u0019\t\"\u0001\u0003:R\u0019qDa/\t\u0011\tu%q\u0017a\u0001\u0003\u001fA\u0001B!.\u0003\u0004\u0012\u0005!q\u0018\u000b\u0004?\t\u0005\u0007b\u0002BO\u0005{\u0003\ra\n\u0005\t\u0005[\u0013\u0019\t\"\u0001\u0003FR\u0019qDa2\t\u0011\tu%1\u0019a\u0001\u0003\u001fA\u0001Ba3\u0003\u0004\u0012\u0005!QZ\u0001\u0007[>tG\u000f[:\u0015\u0007}\u0011y\r\u0003\u0005\u0003\u001e\n%\u0007\u0019AA\b\u0011!\u0011\u0019Na!\u0005\u0002\tU\u0017\u0001C9vCJ$XM]:\u0015\u0007}\u00119\u000e\u0003\u0005\u0003\u001e\nE\u0007\u0019AA\b\u0011!\u0011\tLa!\u0005\u0002\tmGcA\u0010\u0003^\"A!Q\u0014Bm\u0001\u0004\ty\u0001\u0003\u0005\u0003b\n\rE\u0011\u0001Br\u0003\u00159X-Z6t)\ry\"Q\u001d\u0005\t\u0005;\u0013y\u000e1\u0001\u0002\u0010!A!\u0011\u001eBB\t\u0003\u0011Y/A\u0003zK\u0006\u00148\u000fF\u0002 \u0005[D\u0001B!(\u0003h\u0002\u0007\u0011q\u0002\u0005\n\u0005c\u0014\u0019\t\"\u0001\u0003\u0005g\fQ!\u00199qYf$Ra\bB{\u0005oDqA!(\u0003p\u0002\u0007q\u0005\u0003\u0004.\u0005_\u0004\ra\f\u0005\n\u0005w\u0014\u0019\t\"\u0001\u0003\u0005{\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0000\u000e-\u0001#B\b\u0004\u0002\r\u0015\u0011bAB\u0002!\t!1k\\7f!\u0015y1qA\u00140\u0013\r\u0019I\u0001\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\r5!\u0011 a\u0001?\u0005AA-\u001e:bi&|g\u000e\u0003\u0006\u0004\u0012\t\r\u0015\u0011!C\u0005\u0007'\t1B]3bIJ+7o\u001c7wKR\u00111Q\u0003\t\u0005\u0007/\u0019i\"\u0004\u0002\u0004\u001a)\u001911\u0004&\u0002\t1\fgnZ\u0005\u0005\u0007?\u0019IB\u0001\u0004PE*,7\r\u001e")
public class Duration
implements Ordered<Duration>,
Serializable {
    private final long quantity;
    private final TimeUnit unit;
    private final long breachEncapsulationOfQuantity;
    private final TimeUnit breachEncapsulationOfUnit;
    private TimeUnit normalizedUnit;
    private String toNormalizedString;
    private long inBaseUnits;
    private volatile byte bitmap$0;

    public static Duration years(int n) {
        return Duration$.MODULE$.years(n);
    }

    public static Duration weeks(int n) {
        return Duration$.MODULE$.weeks(n);
    }

    public static Duration seconds(int n) {
        return Duration$.MODULE$.seconds(n);
    }

    public static Duration quarters(int n) {
        return Duration$.MODULE$.quarters(n);
    }

    public static Duration months(int n) {
        return Duration$.MODULE$.months(n);
    }

    public static Duration minutes(int n) {
        return Duration$.MODULE$.minutes(n);
    }

    public static Duration milliseconds(long l) {
        return Duration$.MODULE$.milliseconds(l);
    }

    public static Duration hours(int n) {
        return Duration$.MODULE$.hours(n);
    }

    public static Duration daysHoursMinutesSecondsMilliseconds(int n, int n2, int n3, int n4, long l) {
        return Duration$.MODULE$.daysHoursMinutesSecondsMilliseconds(n, n2, n3, n4, l);
    }

    public static Duration days(int n) {
        return Duration$.MODULE$.days(n);
    }

    public static Duration None() {
        return Duration$.MODULE$.None();
    }

    private TimeUnit normalizedUnit$lzycompute() {
        Duration duration = this;
        synchronized (duration) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq<TimeUnit> units = this.unit().descendingUnits();
                long baseAmount = this.inBaseUnits();
                this.normalizedUnit = (TimeUnit)units.find((Function1)new Serializable(this, baseAmount){
                    public static final long serialVersionUID = 0L;
                    private final long baseAmount$1;

                    public final boolean apply(TimeUnit e) {
                        return this.baseAmount$1 % (long)e.getFactor() == 0L;
                    }
                    {
                        this.baseAmount$1 = baseAmount$1;
                    }
                }).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.normalizedUnit;
        }
    }

    private String toNormalizedString$lzycompute() {
        Duration duration = this;
        synchronized (duration) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.toNormalizedString = this.toNormalizedString(this.unit().descendingUnits());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.toNormalizedString;
        }
    }

    private long inBaseUnits$lzycompute() {
        Duration duration = this;
        synchronized (duration) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.inBaseUnits = this.quantity() * (long)this.unit().getFactor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.inBaseUnits;
        }
    }

    public boolean $less(Object that) {
        return Ordered.class.$less((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.class.$greater((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.class.$less$eq((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.class.$greater$eq((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.class.compareTo((Ordered)this, (Object)that);
    }

    public long quantity() {
        return this.quantity;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public CalendarDate addedTo(CalendarDate day) {
        return this.addedTo(day, ZoneIds$.MODULE$.Default());
    }

    public CalendarDate addedTo(CalendarDate day, TimeZone timeZone) {
        return this.addedTo(day, timeZone.toZoneId());
    }

    public CalendarDate addedTo(CalendarDate day, ZoneId zoneId) {
        CalendarDate calendarDate;
        if (this.unit().compareTo(TimeUnit$.MODULE$.Day()) < 0) {
            calendarDate = day;
        } else {
            ZonedDateTime zonedDateTime = day.asJavaZonedDateTimeOnMidnight(zoneId);
            TimeUnit timeUnit = this.unit();
            TimeUnit timeUnit2 = TimeUnit$.MODULE$.Day();
            ZonedDateTime newZonedDateTime = !(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) ? zonedDateTime.plusDays(this.quantity()) : this.addAmountToZonedDateTime(this.inBaseUnits(), zonedDateTime);
            calendarDate = CalendarDate$.MODULE$.from(newZonedDateTime);
        }
        return calendarDate;
    }

    public CalendarYearMonth addedTo(CalendarYearMonth month, TimeZone timeZone) {
        return this.addedTo(month, timeZone.toZoneId());
    }

    public CalendarYearMonth addedTo(CalendarYearMonth month, ZoneId zoneId) {
        CalendarYearMonth calendarYearMonth;
        if (this.unit().compareTo(TimeUnit$.MODULE$.Month()) < 0) {
            calendarYearMonth = month;
        } else {
            ZonedDateTime zonedDateTime = month.asJavaZonedDateTimeOnMidnight(zoneId);
            TimeUnit timeUnit = this.unit();
            TimeUnit timeUnit2 = TimeUnit$.MODULE$.Month();
            ZonedDateTime newZonedDateTime = !(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) ? zonedDateTime.plusMonths(this.quantity()) : this.addAmountToZonedDateTime(this.inBaseUnits(), zonedDateTime);
            calendarYearMonth = CalendarYearMonth$.MODULE$.from(newZonedDateTime);
        }
        return calendarYearMonth;
    }

    public TimePoint addedTo(TimePoint point) {
        return this.addAmountToTimePoint(this.inBaseUnits(), point);
    }

    public ZoneId addedTo$default$2() {
        return ZoneIds$.MODULE$.Default();
    }

    public long breachEncapsulationOfQuantity() {
        return this.breachEncapsulationOfQuantity;
    }

    public TimeUnit breachEncapsulationOfUnit() {
        return this.breachEncapsulationOfUnit;
    }

    public int compare(Duration other) {
        if (!other.unit().isConvertibleTo(this.unit()) && this.quantity() != 0L && other.quantity() != 0L) {
            throw new ClassCastException(new StringBuilder().append((Object)other.toString()).append((Object)" is not convertible to: ").append((Object)this.toString()).toString());
        }
        long difference = this.inBaseUnits() - other.inBaseUnits();
        return difference > 0L ? 1 : (difference < 0L ? -1 : 0);
    }

    public Ratio dividedBy(Duration divisor) {
        this.checkConvertible(divisor);
        return Ratio$.MODULE$.apply(this.inBaseUnits(), divisor.inBaseUnits());
    }

    public boolean equals(Object obj) {
        Duration duration;
        Object object = obj;
        boolean bl = object instanceof Duration ? this.isConvertibleTo(duration = (Duration)object) && this.inBaseUnits() == duration.inBaseUnits() : false;
        return bl;
    }

    public int hashCode() {
        return 31 * ((int)(this.inBaseUnits() ^ this.inBaseUnits() >>> 32) + ((Object)this.unit().valueBaseType()).hashCode());
    }

    public Duration minus(Duration other) {
        this.checkConvertible(other);
        this.checkGreaterThanOrEqualTo(other);
        long newQuantity = this.inBaseUnits() - other.inBaseUnits();
        return new Duration(newQuantity, other.quantity() == 0L ? this.unit().baseUnit() : other.unit().baseUnit());
    }

    public TimeUnit normalizedUnit() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.normalizedUnit$lzycompute() : this.normalizedUnit;
    }

    public Duration plus(Duration other) {
        this.checkConvertible(other);
        long newQuantity = this.inBaseUnits() + other.inBaseUnits();
        return new Duration(newQuantity, other.quantity() == 0L ? this.unit().baseUnit() : other.unit().baseUnit());
    }

    public TimeInterval preceding(LimitValue<TimePoint> end) {
        return TimeInterval$.MODULE$.preceding((Limit)end, this);
    }

    public CalendarInterval startingFromCalendarDate(LimitValue<CalendarDate> start) {
        return CalendarInterval$.MODULE$.startingFrom(start, this);
    }

    public TimeInterval startingFromTimePoint(LimitValue<TimePoint> start) {
        return TimeInterval$.MODULE$.startingFrom((Limit)start, this);
    }

    public CalendarDate subtractedFrom(CalendarDate day, TimeZone timeZone) {
        return this.subtractedFrom(day, timeZone.toZoneId());
    }

    public CalendarDate subtractedFrom(CalendarDate day, ZoneId zoneId) {
        CalendarDate calendarDate;
        if (this.unit().compareTo(TimeUnit$.MODULE$.Day()) < 0) {
            calendarDate = day;
        } else {
            ZonedDateTime zonedDateTime = day.asJavaZonedDateTimeOnMidnight(zoneId);
            ZonedDateTime newZonedDateTime = this.unit().equals(TimeUnit$.MODULE$.Day()) ? zonedDateTime.minusDays(this.quantity()) : this.subtractAmountFromZonedDateTime(this.inBaseUnits(), zonedDateTime);
            calendarDate = CalendarDate$.MODULE$.from(newZonedDateTime);
        }
        return calendarDate;
    }

    public TimePoint subtractedFrom(TimePoint point) {
        return this.addAmountToTimePoint(-1L * this.inBaseUnits(), point);
    }

    public String toNormalizedString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.toNormalizedString$lzycompute() : this.toNormalizedString;
    }

    public String toString() {
        return this.toNormalizedString(this.unit().descendingUnitsForDisplay());
    }

    public void addAmountToCalendar(long amount, Calendar calendar) {
        if (this.unit().isConvertibleToMilliseconds()) {
            calendar.setTimeInMillis(calendar.getTimeInMillis() + amount);
        } else {
            this.checkAmountValid(amount);
            calendar.add(this.unit().javaCalendarConstantForBaseType(), (int)amount);
        }
    }

    public ZonedDateTime addAmountToZonedDateTime(long amount, ZonedDateTime zonedDateTime) {
        ZonedDateTime zonedDateTime2;
        if (this.unit().isConvertibleToMilliseconds()) {
            zonedDateTime2 = ZonedDateTime.ofInstant(Instant.ofEpochMilli(zonedDateTime.toInstant().toEpochMilli() + amount), zonedDateTime.getZone());
        } else {
            this.checkAmountValid(amount);
            zonedDateTime2 = zonedDateTime.plus((int)amount, this.unit().javaZonedDateTImeConstantForBaseType());
        }
        return zonedDateTime2;
    }

    public TimePoint addAmountToTimePoint(long amount, TimePoint point, TimeZone timeZone) {
        TimePoint timePoint;
        if (this.unit().isConvertibleToMilliseconds()) {
            timePoint = TimePoint$.MODULE$.from(amount + point.millisecondsFromEpoc());
        } else {
            Calendar calendar = point.asJavaCalendar(timeZone);
            this.addAmountToCalendar(amount, calendar);
            timePoint = TimePoint$.MODULE$.from(calendar);
        }
        return timePoint;
    }

    public TimePoint addAmountToTimePoint(long amount, TimePoint point) {
        TimePoint timePoint;
        if (this.unit().isConvertibleToMilliseconds()) {
            timePoint = TimePoint$.MODULE$.from(amount + point.millisecondsFromEpoc());
        } else {
            Instant instant = point.asInstant().plus(amount, this.unit().javaZonedDateTImeConstantForBaseType());
            timePoint = TimePoint$.MODULE$.from(instant.toEpochMilli());
        }
        return timePoint;
    }

    public long inBaseUnits() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.inBaseUnits$lzycompute() : this.inBaseUnits;
    }

    public void subtractAmountFromCalendar(long amount, Calendar calendar) {
        this.addAmountToCalendar(-1L * amount, calendar);
    }

    public ZonedDateTime subtractAmountFromZonedDateTime(long amount, ZonedDateTime zonedDateTime) {
        return this.addAmountToZonedDateTime(-1L * amount, zonedDateTime);
    }

    private void checkAmountValid(long amount) {
        Predef$.MODULE$.require(amount >= Integer.MIN_VALUE && amount <= Integer.MAX_VALUE, (Function0)new Serializable(this, amount){
            public static final long serialVersionUID = 0L;
            private final long amount$1;

            public final String apply() {
                return new StringBuilder().append(this.amount$1).append((Object)" is not valid").toString();
            }
            {
                this.amount$1 = amount$1;
            }
        });
    }

    private void checkConvertible(Duration other) {
        Predef$.MODULE$.require(!(!other.unit().isConvertibleTo(this.unit()) && this.quantity() != 0L && other.quantity() != 0L), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Duration $outer;
            private final Duration other$1;

            public final String apply() {
                return new StringBuilder().append((Object)this.other$1.toString()).append((Object)" is not convertible to: ").append((Object)this.$outer.toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
    }

    private void checkGreaterThanOrEqualTo(Duration other) {
        Predef$.MODULE$.require(this.compareTo(other) >= 0, (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Duration $outer;
            private final Duration other$2;

            public final String apply() {
                return new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.$outer), " is before ")).append((Object)this.other$2).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$2 = other$2;
            }
        });
    }

    private boolean isConvertibleTo(Duration other) {
        return this.unit().isConvertibleTo(other.unit());
    }

    private String toNormalizedString(Seq<TimeUnit> units) {
        StringBuffer buffer = new StringBuffer();
        LongRef remainder = new LongRef(this.inBaseUnits());
        BooleanRef first = new BooleanRef(true);
        units.foreach((Function1)new Serializable(this, buffer, remainder, first){
            public static final long serialVersionUID = 0L;
            private final StringBuffer buffer$1;
            private final LongRef remainder$1;
            private final BooleanRef first$1;

            public final void apply(TimeUnit aUnit) {
                Object object;
                long portion = this.remainder$1.elem / (long)aUnit.getFactor();
                if (portion > 0L) {
                    StringBuffer stringBuffer;
                    if (this.first$1.elem) {
                        this.first$1.elem = false;
                        stringBuffer = BoxedUnit.UNIT;
                    } else {
                        stringBuffer = this.buffer$1.append(", ");
                    }
                    object = this.buffer$1.append(aUnit.toString(portion));
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.remainder$1.elem %= (long)aUnit.getFactor();
            }
            {
                this.buffer$1 = buffer$1;
                this.remainder$1 = remainder$1;
                this.first$1 = first$1;
            }
        });
        return buffer.toString();
    }

    public Duration(long quantity, TimeUnit unit) {
        this.quantity = quantity;
        this.unit = unit;
        Ordered.class.$init$((Ordered)this);
        Predef$.MODULE$.require(quantity >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Duration $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Quantity: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.quantity())).append((Object)" must be zero or positive").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.breachEncapsulationOfQuantity = quantity;
        this.breachEncapsulationOfUnit = unit;
    }
}

