/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.baseunits.scala.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.sisioh.baseunits.scala.time.CalendarDate;
import org.sisioh.baseunits.scala.time.CalendarYearMonth;
import org.sisioh.baseunits.scala.time.DayOfMonth;
import org.sisioh.baseunits.scala.time.HourOfDay$;
import org.sisioh.baseunits.scala.time.MonthOfYear;
import org.sisioh.baseunits.scala.time.TimeOfDay;
import org.sisioh.baseunits.scala.time.TimePoint;
import org.sisioh.baseunits.scala.time.ZoneIds$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class TimePoint$
implements Serializable {
    public static final TimePoint$ MODULE$;

    static {
        new TimePoint$();
    }

    public TimePoint apply(long milliseconds) {
        return this.from(milliseconds);
    }

    public Option<Object> unapply(TimePoint timePoint) {
        return new Some((Object)BoxesRunTime.boxToLong((long)timePoint.millisecondsFromEpoc()));
    }

    public TimePoint at(CalendarYearMonth yearMonth, DayOfMonth date, int hour, int minute, int second, int millisecond) {
        return this.at(yearMonth, date, hour, minute, second, millisecond, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at(CalendarYearMonth yearMonth, DayOfMonth date, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        return this.at(yearMonth.year(), yearMonth.month().value(), date.value(), hour, minute, second, millisecond, timeZone.toZoneId());
    }

    public TimePoint at(CalendarYearMonth yearMonth, DayOfMonth date, int hour, int minute, int second, int millisecond, ZoneId zoneId) {
        return this.at(yearMonth.year(), yearMonth.month().value(), date.value(), hour, minute, second, millisecond, zoneId);
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return this.at(year, month, date, hour, minute, second, millisecond, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return this.from(calendar.getTime().getTime());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second, int millisecond, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, date, hour, minute, second, millisecond * 1000000, zoneId);
        return this.from(zonedDateTime);
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second) {
        return this.at(year, month, date, hour, minute, second, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second, TimeZone timeZone) {
        return this.at(year, month, date, hour, minute, second, 0, timeZone.toZoneId());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, int second, ZoneId zoneId) {
        return this.at(year, month, date, hour, minute, second, 0, zoneId);
    }

    public TimePoint at(int year, int month, int date, int hour, int minute) {
        return this.at(year, month, date, hour, minute, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, TimeZone timeZone) {
        return this.at(year, month, date, hour, minute, 0, 0, timeZone.toZoneId());
    }

    public TimePoint at(int year, int month, int date, int hour, int minute, ZoneId zoneId) {
        return this.at(year, month, date, hour, minute, 0, 0, zoneId);
    }

    public TimePoint at(int year, MonthOfYear month, DayOfMonth date, int hour, int minute, int second, int millisecond) {
        return this.at(year, month, date, hour, minute, second, millisecond, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at(int year, MonthOfYear month, DayOfMonth date, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        return this.at(year, month.value(), date.value(), hour, minute, second, millisecond, timeZone.toZoneId());
    }

    public TimePoint at(int year, MonthOfYear month, DayOfMonth date, int hour, int minute, int second, int millisecond, ZoneId zoneId) {
        return this.at(year, month.value(), date.value(), hour, minute, second, millisecond, zoneId);
    }

    public TimePoint at12hr(int year, int month, int date, int hour, String amPm, int minute, int second, int millisecond) {
        return this.at(year, month, date, HourOfDay$.MODULE$.convertTo24hour(hour, amPm), minute, second, millisecond, ZoneIds$.MODULE$.Default());
    }

    public TimePoint at12hr(int year, int month, int date, int hour, String amPm, int minute, int second, int millisecond, TimeZone timeZone) {
        return this.at(year, month, date, HourOfDay$.MODULE$.convertTo24hour(hour, amPm), minute, second, millisecond, timeZone.toZoneId());
    }

    public TimePoint at12hr(int year, int month, int date, int hour, String amPm, int minute, int second, int millisecond, ZoneId zoneId) {
        return this.at(year, month, date, HourOfDay$.MODULE$.convertTo24hour(hour, amPm), minute, second, millisecond, zoneId);
    }

    public TimePoint atMidnight(CalendarDate calendarDate) {
        return this.atMidnight(calendarDate, ZoneIds$.MODULE$.Default());
    }

    public TimePoint atMidnight(CalendarDate calendarDate, TimeZone timeZone) {
        return this.at(calendarDate.asCalendarMonth(), calendarDate.day(), 0, 0, 0, 0, timeZone.toZoneId());
    }

    public TimePoint atMidnight(CalendarDate calendarDate, ZoneId zoneId) {
        return this.at(calendarDate.asCalendarMonth(), calendarDate.day(), 0, 0, 0, 0, zoneId);
    }

    public TimePoint atMidnight(int year, int month, int date) {
        return this.atMidnight(year, month, date, ZoneIds$.MODULE$.Default());
    }

    public TimePoint atMidnight(int year, int month, int date, TimeZone timeZone) {
        return this.at(year, month, date, 0, 0, 0, 0, timeZone.toZoneId());
    }

    public TimePoint atMidnight(int year, int month, int date, ZoneId zoneId) {
        return this.at(year, month, date, 0, 0, 0, 0, zoneId);
    }

    public TimePoint from(Calendar calendar) {
        return this.from(calendar.getTime());
    }

    public TimePoint from(CalendarDate date, TimeOfDay time) {
        return this.from(date, time, ZoneIds$.MODULE$.Default());
    }

    public TimePoint from(CalendarDate date, TimeOfDay time, TimeZone timeZone) {
        return this.at(date.asCalendarMonth(), date.day(), time.hour().value(), time.minute().value(), 0, 0, timeZone.toZoneId());
    }

    public TimePoint from(CalendarDate date, TimeOfDay time, ZoneId zoneId) {
        return this.at(date.asCalendarMonth(), date.day(), time.hour().value(), time.minute().value(), 0, 0, zoneId);
    }

    public TimePoint from(Date javaDate) {
        return this.from(javaDate.getTime());
    }

    public TimePoint from(Instant instant) {
        return this.from(instant.toEpochMilli());
    }

    public TimePoint from(ZonedDateTime zonedDateTime) {
        return this.from(zonedDateTime.toInstant().toEpochMilli());
    }

    /*
     * WARNING - void declaration
     */
    public TimePoint from(long milliseconds) {
        void var3_2;
        TimePoint result = new TimePoint(milliseconds);
        return var3_2;
    }

    public TimePoint parse(String dateTimeString, String pattern, TimeZone timeZone) {
        return this.parse(dateTimeString, pattern, timeZone.toZoneId());
    }

    public TimePoint parse(String dateTimeString, String pattern, ZoneId zoneId) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone(zoneId));
        Date date = sdf.parse(dateTimeString);
        return this.from(date);
    }

    public ZoneId parse$default$3() {
        return ZoneIds$.MODULE$.Default();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimePoint$() {
        MODULE$ = this;
    }
}

