/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.openfact.models.DocumentLineModel;
import org.openfact.models.FileModel;
import org.openfact.models.OrganizationModel;
import org.openfact.models.SendEventModel;
import org.openfact.models.types.DestinyType;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.provider.ProviderEvent;
import org.w3c.dom.Document;

public interface DocumentModel {
    public static final String DOCUMENT_TYPE = "documentType";
    public static final String DOCUMENT_ID = "documentId";
    public static final String DOCUMENT_CURRENCY_CODE = "documentCurrencyCode";
    public static final String CUSTOMER_REGISTRATION_NAME = "customerRegistrationName";
    public static final String CUSTOMER_ASSIGNED_ACCOUNT_ID = "customerAssignedAccountId";
    public static final String CUSTOMER_ELECTRONIC_MAIL = "customerElectronicMail";
    public static final String CREATED_TIMESTAMP = "createdTimestamp";
    public static final String ENABLED = "enabled";
    public static final String REQUIRED_ACTIONS = "requiredActions";
    public static final String SEND_EVENT_DESTINY = "destiny";
    public static final String SEND_EVENT_STATUS = "status";

    public String getId();

    public String getDocumentId();

    public String getDocumentType();

    public LocalDateTime getCreatedTimestamp();

    public boolean isEnabled();

    public void disable();

    public List<DocumentLineModel> getDocumentLines();

    public DocumentLineModel addDocumentLine();

    public boolean removeDocumentLine(DocumentLineModel var1);

    public OrganizationModel getOrganization();

    public String getDocumentCurrencyCode();

    public void setDocumentCurrencyCode(String var1);

    public String getCustomerRegistrationName();

    public void setCustomerRegistrationName(String var1);

    public String getCustomerAssignedAccountId();

    public void setCustomerAssignedAccountId(String var1);

    public String getCustomerElectronicMail();

    public void setCustomerElectronicMail(String var1);

    public FileModel getXmlAsFile();

    public void attachXmlFile(FileModel var1);

    public Document getXmlAsDocument();

    public JSONObject getXmlAsJSONObject();

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public List<String> getAttribute(String var1);

    public Map<String, List<String>> getAttributes();

    public Set<String> getRequiredActions();

    public void addRequiredAction(String var1);

    public void removeRequiredAction(String var1);

    public void addRequiredAction(DocumentRequiredAction var1);

    public void removeRequiredAction(DocumentRequiredAction var1);

    public int getCustomerSendEventFailures();

    public void incrementCustomerSendEventFailures();

    public int getThirdPartySendEventFailures();

    public void incrementThirdPartySendEventFailures();

    public SendEventModel addSendEvent(DestinyType var1);

    public SendEventModel getSendEventById(String var1);

    public boolean removeSendEvent(SendEventModel var1);

    public List<SendEventModel> getSendEvents();

    public List<SendEventModel> getSendEvents(Integer var1, Integer var2);

    public List<SendEventModel> searchForSendEvent(Map<String, String> var1);

    public List<SendEventModel> searchForSendEvent(Map<String, String> var1, int var2, int var3);

    public List<DocumentModel> getAttachedDocumentsAsOrigin();

    public List<DocumentModel> getAttachedDocumentsAsDestiny();

    public void addAttachedDocument(DocumentModel var1);

    public boolean removeAttachedDocument(DocumentModel var1);

    public static interface DocumentRemovedEvent
    extends ProviderEvent {
        public OrganizationModel getOrganization();

        public DocumentModel getDocument();
    }

    @FunctionalInterface
    public static interface DocumentPostCreateEvent
    extends ProviderEvent {
        public DocumentModel getCreatedDocument();
    }

    @FunctionalInterface
    public static interface DocumentCreationEvent
    extends ProviderEvent {
        public DocumentModel getCreatedDocument();
    }
}

