/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openfact.common.converts.DateUtils;
import org.openfact.models.DocumentModel;
import org.openfact.models.ScrollModel;
import org.openfact.models.search.PagingModel;
import org.openfact.models.search.SearchCriteriaFilterOperator;
import org.openfact.models.search.SearchResultsModel;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.models.types.DocumentType;

public interface DocumentQuery {
    public DocumentQuery currencyCode(String ... var1);

    public DocumentQuery documentType(DocumentType ... var1);

    public DocumentQuery documentType(String ... var1);

    public DocumentQuery requiredAction(DocumentRequiredAction ... var1);

    public DocumentQuery filterText(String var1);

    public DocumentQuery filterTextReplaceAsterisk(String var1, String ... var2);

    public DocumentQuery customerSendEventFailures(int var1, boolean var2);

    public DocumentQuery thirdPartySendEventFailures(int var1, boolean var2);

    public DocumentQuery enabled(boolean var1);

    public DocumentQuery addFilter(String var1, String var2);

    public DocumentQuery addFilter(Map<String, String> var1);

    public DocumentQuery addFilter(String var1, Object var2, SearchCriteriaFilterOperator var3);

    public DocumentQuery fromDate(LocalDateTime var1, boolean var2);

    public DocumentQuery toDate(LocalDateTime var1, boolean var2);

    public EntityQuery entityQuery();

    public CountQuery countQuery();

    default public DocumentQuery applyQuery(String query) {
        if (!query.trim().isEmpty()) {
            Map<QueryOperator, String> params = QueryOperator.mapQuery(query);
            for (Map.Entry<QueryOperator, String> map : params.entrySet()) {
                switch (map.getKey()) {
                    case FILTER_TEXT: {
                        this.filterText(map.getValue());
                        break;
                    }
                    case CURRENCY_CODE: {
                        this.currencyCode(map.getValue().split(","));
                        break;
                    }
                    case DOCUMENT_TYPE: {
                        this.documentType(map.getValue().split(","));
                        break;
                    }
                    case AFTER: {
                        LocalDate after = DateUtils.asLocalDate((String)map.getValue());
                        if (after == null) break;
                        this.fromDate(after.atStartOfDay(), true);
                        break;
                    }
                    case BEFORE: {
                        LocalDate before = DateUtils.asLocalDate((String)map.getValue());
                        if (before == null) break;
                        this.toDate(before.plusDays(1L).atStartOfDay(), true);
                    }
                }
            }
        }
        return this;
    }

    public static enum QueryOperator {
        FILTER_TEXT("filtertext"),
        CURRENCY_CODE("currency_code"),
        DOCUMENT_TYPE("document_type"),
        AFTER("after"),
        BEFORE("before");

        private String name;

        private QueryOperator(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Optional<QueryOperator> getByName(String name) {
            return Arrays.stream(QueryOperator.values()).filter(f -> f.getName().equals(name)).findFirst();
        }

        public static Map<QueryOperator, String> mapQuery(String query) {
            String[] userQueries;
            HashMap<QueryOperator, String> result = new HashMap<QueryOperator, String>();
            for (String userQuery : userQueries = query.trim().split(" ")) {
                String[] operator = userQuery.split(":");
                QueryOperator.getByName(operator[0]).ifPresent(queryOperator -> result.put((QueryOperator)((Object)queryOperator), operator[1]));
            }
            return result;
        }
    }

    public static interface CountQuery {
        public int getTotalCount();
    }

    public static interface SearchResultEntityQuery {
        public SearchResultsModel<DocumentModel> getSearchResult();

        public SearchResultsModel<DocumentModel> getSearchResult(PagingModel var1);
    }

    public static interface ScrollEntityQuery {
        public ScrollModel<DocumentModel> getScrollResult(int var1);

        public ScrollModel<List<DocumentModel>> getScrollResultList(int var1);
    }

    public static interface ListEntityQuery {
        public List<DocumentModel> getResultList();

        public ListEntityQuery firstResult(int var1);

        public ListEntityQuery maxResults(int var1);
    }

    public static interface EntityQuery {
        public EntityQuery orderByAsc(String ... var1);

        public EntityQuery orderByDesc(String ... var1);

        public ListEntityQuery resultList();

        public SearchResultEntityQuery searchResult();

        public ScrollEntityQuery resultScroll();
    }
}

