/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models.search;

import java.util.ArrayList;
import java.util.List;
import org.openfact.models.search.OrderByModel;
import org.openfact.models.search.PagingModel;
import org.openfact.models.search.SearchCriteriaFilterModel;
import org.openfact.models.search.SearchCriteriaFilterOperator;

public class SearchCriteriaModel {
    private List<SearchCriteriaFilterModel> filters = new ArrayList<SearchCriteriaFilterModel>();
    private List<OrderByModel> orders = new ArrayList<OrderByModel>();
    private PagingModel paging;

    public void addFilter(String name, Object value, SearchCriteriaFilterOperator operator) {
        SearchCriteriaFilterModel filter = new SearchCriteriaFilterModel();
        filter.setName(name);
        filter.setValue(value);
        filter.setOperator(operator);
        this.filters.add(filter);
    }

    public void addFilter(SearchCriteriaFilterModel filter) {
        this.filters.add(filter);
    }

    public void addOrder(String name, boolean ascending) {
        OrderByModel orderBy = new OrderByModel();
        orderBy.setName(name);
        orderBy.setAscending(ascending);
        this.orders.add(orderBy);
    }

    public void addOrder(OrderByModel orderBy) {
        this.orders.add(orderBy);
    }

    public void setPage(int page) {
        if (this.paging == null) {
            this.paging = new PagingModel();
        }
        this.getPaging().setPage(page);
    }

    public void setPageSize(int pageSize) {
        if (this.paging == null) {
            this.paging = new PagingModel();
        }
        this.getPaging().setPageSize(pageSize);
    }

    public List<SearchCriteriaFilterModel> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SearchCriteriaFilterModel> filters) {
        this.filters = filters;
    }

    public PagingModel getPaging() {
        return this.paging;
    }

    public void setPaging(PagingModel paging) {
        this.paging = paging;
    }

    public List<OrderByModel> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderByModel> orders) {
        this.orders = orders;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 31 * result + (this.orders == null ? 0 : this.orders.hashCode());
        result = 31 * result + (this.paging == null ? 0 : this.paging.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCriteriaModel other = (SearchCriteriaModel)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        if (this.orders == null ? other.orders != null : !this.orders.equals(other.orders)) {
            return false;
        }
        return !(this.paging == null ? other.paging != null : !this.paging.equals(other.paging));
    }
}

