/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.provider;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.openfact.provider.ProviderConfigProperty;

public class ProviderConfigurationBuilder {
    private List<ProviderConfigProperty> properties = new LinkedList<ProviderConfigProperty>();

    private ProviderConfigurationBuilder() {
    }

    public static ProviderConfigurationBuilder create() {
        return new ProviderConfigurationBuilder();
    }

    public ProviderConfigPropertyBuilder property() {
        return new ProviderConfigPropertyBuilder();
    }

    public ProviderConfigurationBuilder property(ProviderConfigProperty property) {
        this.properties.add(property);
        return this;
    }

    public ProviderConfigurationBuilder property(String name, String label, String helpText, String type, Object defaultValue, List<String> options, boolean secret) {
        ProviderConfigProperty property = new ProviderConfigProperty(name, label, helpText, type, defaultValue);
        property.setOptions(options);
        property.setSecret(secret);
        this.properties.add(property);
        return this;
    }

    public ProviderConfigurationBuilder property(String name, String label, String helpText, String type, Object defaultValue, List<String> options) {
        ProviderConfigProperty property = new ProviderConfigProperty(name, label, helpText, type, defaultValue);
        property.setOptions(options);
        this.properties.add(property);
        return this;
    }

    public List<ProviderConfigProperty> build() {
        return this.properties;
    }

    public class ProviderConfigPropertyBuilder {
        private String name;
        private String label;
        private String helpText;
        private String type;
        private Object defaultValue;
        private List<String> options;
        private boolean secret;

        public ProviderConfigPropertyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProviderConfigPropertyBuilder label(String label) {
            this.label = label;
            return this;
        }

        public ProviderConfigPropertyBuilder helpText(String helpText) {
            this.helpText = helpText;
            return this;
        }

        public ProviderConfigPropertyBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ProviderConfigPropertyBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ProviderConfigPropertyBuilder options(String ... options) {
            this.options = Arrays.asList(options);
            return this;
        }

        public ProviderConfigPropertyBuilder options(List<String> options) {
            this.options = options;
            return this;
        }

        public ProviderConfigPropertyBuilder secret(boolean secret) {
            this.secret = secret;
            return this;
        }

        public ProviderConfigurationBuilder add() {
            ProviderConfigProperty property = new ProviderConfigProperty();
            property.setName(this.name);
            property.setLabel(this.label);
            property.setHelpText(this.helpText);
            property.setType(this.type);
            property.setDefaultValue(this.defaultValue);
            property.setOptions(this.options);
            property.setSecret(this.secret);
            ProviderConfigurationBuilder.this.properties.add(property);
            return ProviderConfigurationBuilder.this;
        }
    }
}

