package skinny

import scalikejdbc.config._
import skinny.util.{ TypesafeConfigReader => sConfigReader }

/**
  * DB setup executor with default settings
  */
case class SkinnyDBsWithEnv(envValue: String)
    extends DBs
    with TypesafeConfigReader
    with TypesafeConfig
    with NoEnvPrefix {

  // Replacing Config because (at least) ScalikeJDBC 2.0.4 or lower versions doesn't support default values
  override val config = sConfigReader.config(envValue)

}
