package skinny.orm.feature

/**
 * Provides APIs on Id.
 *
 * @tparam Id id
 */
trait IdFeature[Id] {

  /**
   * Primary key should be Database's auto-increment value if true.
   */
  def useAutoIncrementPrimaryKey: Boolean = true

  /**
   * Primary key generation should be done by #generateNewId if true.
   */
  def useExternalIdGenerator: Boolean = false

  /**
   * Generates auto-generated new Id.
   *
   * @return id
   */
  def generateId: Id = throw new IllegalStateException("If you use external Id generator, you must implement this method.")

  /**
   * Returns actual value from identity value.
   *
   * @param id identity
   * @return  actual value
   */
  def idToRawValue(id: Id): Any

  /**
   * Returns identity value from raw value.
   * @param rawValue raw value
   * @return identity value
   */
  def rawValueToId(rawValue: Any): Id

  /**
   * Returns actual value from identity value.
   *
   * @param id identity
   * @tparam A actual value type
   * @return  actual value
   */
  def convertAutoGeneratedIdToId[A](id: Long): Option[Id] = Option(rawValueToId(id))

}
