/*
 * Copyright (c) 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 David Berkman
 *
 * This file is part of the SmallMind Code Project.
 *
 * The SmallMind Code Project is free software, you can redistribute
 * it and/or modify it under either, at your discretion...
 *
 * 1) The terms of GNU Affero General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at
 * your option) any later version.
 *
 * ...or...
 *
 * 2) The terms of the Apache License, Version 2.0.
 *
 * The SmallMind Code Project is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License or Apache License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * and the Apache License along with the SmallMind Code Project. If not, see
 * <http://www.gnu.org/licenses/> or <http://www.apache.org/licenses/LICENSE-2.0>.
 *
 * Additional permission under the GNU Affero GPL version 3 section 7
 * ------------------------------------------------------------------
 * If you modify this Program, or any covered work, by linking or
 * combining it with other code, such other code is not for that reason
 * alone subject to any of the requirements of the GNU Affero GPL
 * version 3.
 */
package org.smallmind.claxon.emitter.datadog;

import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import org.smallmind.claxon.registry.PushEmitter;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.QuantityType;
import org.smallmind.claxon.registry.Tag;

public class DataDogEmitter extends PushEmitter {

  private final StatsDClient statsdClient;
  private final boolean countAsCount;

  public DataDogEmitter () {

    this(null, "localhost", 8125, true, null);
  }

  public DataDogEmitter (String prefix, String hostName, int port, boolean countAsCount, Tag... constantTags) {

    this.countAsCount = countAsCount;

    statsdClient = new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostName).port(port).constantTags(translateTags(constantTags)).build();
  }

  @Override
  public void record (String meterName, Tag[] tags, Quantity[] quantities) {

    String[] translatedTags = translateTags(tags);

    for (Quantity quantity : quantities) {
      if (countAsCount && QuantityType.COUNT.equals(quantity.getType())) {
        statsdClient.count(meterName + '.' + quantity.getName(), quantity.getValue(), translatedTags);
      } else {
        statsdClient.gauge(meterName + '.' + quantity.getName(), quantity.getValue(), translatedTags);
      }
    }
  }

  private String[] translateTags (Tag... tags) {

    String[] translatedtags = null;

    if ((tags != null) && (tags.length > 0)) {

      int index = 0;

      translatedtags = new String[tags.length];
      for (Tag tag : tags) {
        translatedtags[index++] = tag.getKey() + ':' + tag.getValue();
      }
    }

    return translatedtags;
  }
}
