/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.emitter.datadog;

import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;
import org.smallmind.claxon.registry.PushEmitter;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.QuantityType;
import org.smallmind.claxon.registry.Tag;

public class DataDogEmitter
extends PushEmitter {
    private final StatsDClient statsdClient;
    private final boolean countAsCount;

    public DataDogEmitter() {
        this(null, "localhost", 8125, true, null);
    }

    public DataDogEmitter(String prefix, String hostName, int port, boolean countAsCount, Tag ... constantTags) {
        this.countAsCount = countAsCount;
        this.statsdClient = new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostName).port(port).constantTags(this.translateTags(constantTags)).build();
    }

    public void record(String meterName, Tag[] tags, Quantity[] quantities) {
        String[] translatedTags = this.translateTags(tags);
        Quantity[] quantityArray = quantities;
        int n = quantities.length;
        int n2 = 0;
        while (n2 < n) {
            Quantity quantity = quantityArray[n2];
            if (this.countAsCount && QuantityType.COUNT.equals((Object)quantity.getType())) {
                this.statsdClient.count(String.valueOf(meterName) + '.' + quantity.getName(), quantity.getValue(), translatedTags);
            } else {
                this.statsdClient.gauge(String.valueOf(meterName) + '.' + quantity.getName(), quantity.getValue(), translatedTags);
            }
            ++n2;
        }
    }

    private String[] translateTags(Tag ... tags) {
        String[] translatedtags = null;
        if (tags != null && tags.length > 0) {
            int index = 0;
            translatedtags = new String[tags.length];
            Tag[] tagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                translatedtags[index++] = String.valueOf(tag.getKey()) + ':' + tag.getValue();
                ++n2;
            }
        }
        return translatedtags;
    }
}

