/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry;

import java.util.Arrays;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.smallmind.claxon.registry.ClaxonConfiguration;
import org.smallmind.claxon.registry.Emitter;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.MeasurableTracker;
import org.smallmind.claxon.registry.NoOpMeter;
import org.smallmind.claxon.registry.ObservableTracker;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.Meter;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.scribe.pen.LoggerManager;

public class ClaxonRegistry {
    private final ConcurrentHashMap<String, Emitter> emitterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<RegistryKey, NamedMeter<?>> meterMap = new ConcurrentHashMap();
    private final Set<RegistryKey> noopSet = ConcurrentHashMap.newKeySet();
    private final MeasurableTracker measurableTracker;
    private final ObservableTracker observableTracker;
    private final CollectionWorker collectionWorker = new CollectionWorker();
    private final ClaxonConfiguration configuration;

    public ClaxonRegistry(ClaxonConfiguration configuration) {
        Thread workerThread = new Thread(this.collectionWorker);
        this.configuration = configuration;
        this.measurableTracker = new MeasurableTracker(this);
        this.observableTracker = new ObservableTracker(this);
        workerThread.setDaemon(true);
        workerThread.start();
    }

    public void initializeInstrumentation() {
        Instrument.register(this);
    }

    public ClaxonConfiguration getConfiguration() {
        return this.configuration;
    }

    public void stop() throws InterruptedException {
        this.collectionWorker.stop();
    }

    public Emitter getEmitter(String name) {
        return this.emitterMap.get(name);
    }

    public ClaxonRegistry bind(String name, Emitter emitter) {
        this.emitterMap.put(name, emitter);
        return this;
    }

    public <M extends Meter> M register(Class<?> caller, MeterBuilder<M> builder, Tag ... tags) {
        RegistryKey key = new RegistryKey(caller, tags);
        if (this.noopSet.contains(key)) {
            return NoOpMeter.instance();
        }
        NamedMeter<Object> namedMeter = this.meterMap.get(key);
        if (namedMeter == null) {
            String meterName = this.configuration.getNamingStrategy().from(caller);
            if (meterName == null) {
                this.noopSet.add(key);
                return NoOpMeter.instance();
            }
            namedMeter = new NamedMeter<M>(meterName, builder.build(this.configuration.getClock()));
            NamedMeter<M> previousNamedMeter = this.meterMap.putIfAbsent(key, namedMeter);
            if (previousNamedMeter != null) {
                namedMeter = previousNamedMeter;
            }
        }
        return (M)namedMeter.getMeter();
    }

    public void unregister(Class<?> caller, Tag ... tags) {
        this.meterMap.remove(new RegistryKey(caller, tags));
    }

    public <O extends Observable> O track(Class<?> caller, MeterBuilder<?> builder, O observable, Tag ... tags) {
        return this.observableTracker.track(caller, builder, observable, tags);
    }

    public <T> T track(Class<?> caller, MeterBuilder<?> builder, T measured, Function<T, Long> measurement, Tag ... tags) {
        return this.measurableTracker.track(caller, builder, measured, measurement, tags);
    }

    private class CollectionWorker
    implements Runnable {
        private final CountDownLatch finishLatch = new CountDownLatch(1);
        private final CountDownLatch exitLatch = new CountDownLatch(1);

        private CollectionWorker() {
        }

        public void stop() throws InterruptedException {
            this.finishLatch.countDown();
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.finishLatch.await(ClaxonRegistry.this.configuration.getCollectionStint().getTime(), ClaxonRegistry.this.configuration.getCollectionStint().getTimeUnit())) {
                        ClaxonRegistry.this.measurableTracker.sweepAndUpdate();
                        ClaxonRegistry.this.observableTracker.sweep();
                        for (Map.Entry<RegistryKey, NamedMeter<?>> namedMeterEntry : ClaxonRegistry.this.meterMap.entrySet()) {
                            Tag[] mergedTags;
                            Quantity[] quantities = ((Meter)namedMeterEntry.getValue().getMeter()).record();
                            if (quantities == null || quantities.length <= 0) continue;
                            Tag[] meterTags = namedMeterEntry.getKey().getTags();
                            if (ClaxonRegistry.this.configuration.getRegistryTags() == null || ClaxonRegistry.this.configuration.getRegistryTags().length == 0) {
                                mergedTags = meterTags;
                            } else if (meterTags == null || meterTags.length == 0) {
                                mergedTags = ClaxonRegistry.this.configuration.getRegistryTags();
                            } else {
                                mergedTags = new Tag[ClaxonRegistry.this.configuration.getRegistryTags().length + meterTags.length];
                                System.arraycopy(ClaxonRegistry.this.configuration.getRegistryTags(), 0, mergedTags, 0, ClaxonRegistry.this.configuration.getRegistryTags().length);
                                System.arraycopy(meterTags, 0, mergedTags, ClaxonRegistry.this.configuration.getRegistryTags().length, meterTags.length);
                            }
                            for (Emitter emitter : ClaxonRegistry.this.emitterMap.values()) {
                                try {
                                    emitter.record(namedMeterEntry.getValue().getName(), mergedTags, quantities);
                                }
                                catch (Exception exception) {
                                    LoggerManager.getLogger(ClaxonRegistry.class).error((Throwable)exception);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ClaxonRegistry.class).error((Throwable)interruptedException);
                    this.finishLatch.countDown();
                    this.exitLatch.countDown();
                }
            }
            finally {
                this.exitLatch.countDown();
            }
        }
    }

    private static class NamedMeter<M extends Meter> {
        private final String name;
        private final M meter;

        public NamedMeter(String name, M meter) {
            this.name = name;
            this.meter = meter;
        }

        public String getName() {
            return this.name;
        }

        public M getMeter() {
            return this.meter;
        }
    }

    private static class RegistryKey {
        private final Class<?> caller;
        private final Tag[] tags;

        public RegistryKey(Class<?> caller, Tag ... tags) {
            this.caller = caller;
            this.tags = tags;
        }

        public Class<?> getCaller() {
            return this.caller;
        }

        public Tag[] getTags() {
            return this.tags;
        }

        public int hashCode() {
            return this.caller.hashCode() * 31 + (this.tags == null ? 0 : Arrays.hashCode(this.tags));
        }

        public boolean equals(Object obj) {
            return obj instanceof RegistryKey && ((RegistryKey)obj).getCaller().equals(this.caller) && Arrays.equals(((RegistryKey)obj).getTags(), this.tags);
        }
    }
}

