/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.smallmind.claxon.registry.ClaxonRegistry;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.Meter;
import org.smallmind.claxon.registry.meter.MeterBuilder;

public class MeasurableTracker {
    private final ConcurrentHashMap<Reference<?>, Measurable> measurableMap = new ConcurrentHashMap();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final ClaxonRegistry registry;

    public MeasurableTracker(ClaxonRegistry registry) {
        this.registry = registry;
    }

    public <T> T track(Class<?> caller, MeterBuilder<?> builder, T measured, Function<T, Long> measurement, Tag ... tags) {
        this.measurableMap.put(new WeakReference<Object>(measured, this.referenceQueue), new Measurable(caller, builder, measurement, tags));
        return measured;
    }

    public void sweepAndUpdate() {
        Reference<Object> sweptReference;
        while ((sweptReference = this.referenceQueue.poll()) != null) {
            Measurable measurable = this.measurableMap.remove(sweptReference);
            if (measurable == null) continue;
            this.registry.unregister(measurable.getCaller(), measurable.getTags());
        }
        for (Map.Entry<Reference<?>, Measurable> measurableEntry : this.measurableMap.entrySet()) {
            Object measured = measurableEntry.getKey().get();
            if (measured == null) continue;
            ((Meter)this.registry.register(measurableEntry.getValue().getCaller(), measurableEntry.getValue().getBuilder(), measurableEntry.getValue().getTags())).update(measurableEntry.getValue().getMeasurement().apply(measured));
        }
    }

    private static class Measurable {
        private final MeterBuilder<?> builder;
        private final Tag[] tags;
        private final Function<Object, Long> measurement;
        private final Class<?> caller;

        public Measurable(Class<?> caller, MeterBuilder<?> builder, Function<?, Long> measurement, Tag ... tags) {
            this.caller = caller;
            this.builder = builder;
            this.tags = tags;
            this.measurement = measurement;
        }

        public Class<?> getCaller() {
            return this.caller;
        }

        public Tag[] getTags() {
            return this.tags;
        }

        public MeterBuilder<?> getBuilder() {
            return this.builder;
        }

        public Function<Object, Long> getMeasurement() {
            return this.measurement;
        }
    }
}

