/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Observable;
import org.smallmind.claxon.registry.ClaxonRegistry;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.MeterBuilder;

public class ObservableTracker {
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final ClaxonRegistry registry;

    public ObservableTracker(ClaxonRegistry registry) {
        this.registry = registry;
    }

    public <O extends Observable> O track(Class<?> caller, MeterBuilder<?> builder, O observable, Tag ... tags) {
        new RegisteredWeakReference<Object>(observable, this.referenceQueue, caller, tags);
        observable.addObserver((obs, arg) -> {
            Object meter = this.registry.register(caller, builder, tags);
            if (Number.class.isAssignableFrom(arg.getClass())) {
                meter.update(((Number)arg).longValue());
            } else if (String.class.equals(arg.getClass())) {
                meter.update(Long.parseLong((String)arg));
            } else {
                throw new IllegalArgumentException("Must be a long value(" + arg + ")");
            }
        });
        return observable;
    }

    public void sweep() {
        Reference<Object> sweptReference;
        while ((sweptReference = this.referenceQueue.poll()) != null) {
            this.registry.unregister(((RegisteredWeakReference)sweptReference).getCaller(), ((RegisteredWeakReference)sweptReference).getTags());
        }
    }

    private static class RegisteredWeakReference<O extends Observable>
    extends WeakReference<O> {
        private final Tag[] tags;
        private final Class<?> caller;

        public RegisteredWeakReference(O referent, ReferenceQueue<? super O> q, Class<?> caller, Tag ... tags) {
            super(referent, q);
            this.caller = caller;
            this.tags = tags;
        }

        public Class<?> getCaller() {
            return this.caller;
        }

        public Tag[] getTags() {
            return this.tags;
        }
    }
}

