/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry;

import java.util.Observable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.smallmind.claxon.registry.ClaxonRegistry;
import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.Instrumentation;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.Meter;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.nutsnbolts.util.SansResultExecutable;
import org.smallmind.nutsnbolts.util.WithResultExecutable;

public class WorkingInstrumentation
implements Instrumentation {
    private final ClaxonRegistry registry;
    private final MeterBuilder<?> builder;
    private final Tag[] tags;
    private final Class<?> caller;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public WorkingInstrumentation(ClaxonRegistry registry, Class<?> caller, MeterBuilder<?> builder, Tag ... tags) {
        this.registry = registry;
        this.caller = caller;
        this.builder = builder;
        this.tags = tags;
    }

    @Override
    public WorkingInstrumentation as(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @Override
    public <O extends Observable> O track(O observable) {
        return observable == null ? null : (O)this.registry.track(this.caller, this.builder, observable, this.tags);
    }

    @Override
    public <T> T track(T measured, Function<T, Long> measurement) {
        return measurement == null ? measured : this.registry.track(this.caller, this.builder, measured, measurement, this.tags);
    }

    @Override
    public void update(long value) {
        ((Meter)this.registry.register(this.caller, this.builder, this.tags)).update(value);
    }

    @Override
    public void update(long value, TimeUnit valueTimeUnit) {
        ((Meter)this.registry.register(this.caller, this.builder, this.tags)).update(this.timeUnit.convert(value, valueTimeUnit));
    }

    @Override
    public void on(SansResultExecutable sansResultExecutable) throws Throwable {
        if (sansResultExecutable != null) {
            Object meter = this.registry.register(this.caller, this.builder, this.tags);
            Clock clock = this.registry.getConfiguration().getClock();
            long start = clock.monotonicTime();
            sansResultExecutable.execute();
            meter.update(this.timeUnit.convert(clock.monotonicTime() - start, TimeUnit.NANOSECONDS));
        }
    }

    @Override
    public <T> T on(WithResultExecutable<T> withResultExecutable) throws Throwable {
        if (withResultExecutable == null) {
            return null;
        }
        Object meter = this.registry.register(this.caller, this.builder, this.tags);
        Clock clock = this.registry.getConfiguration().getClock();
        long start = clock.monotonicTime();
        Object result = withResultExecutable.execute();
        meter.update(this.timeUnit.convert(clock.monotonicTime() - start, TimeUnit.NANOSECONDS));
        return (T)result;
    }
}

