/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.aggregate;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.claxon.registry.aggregate.Aggregate;

public class Averaged
implements Aggregate {
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentLinkedQueue<Long> valueQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger size = new AtomicInteger();
    private long accumulatedValue;
    private int accumulatedCount;

    @Override
    public void update(long value) {
        if (this.lock.tryLock()) {
            try {
                this.sweep();
                this.accumulatedValue += value;
                ++this.accumulatedCount;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.size.incrementAndGet();
            this.valueQueue.add(value);
        }
    }

    public void sweep() {
        int cap = this.size.get();
        int n = 0;
        if (cap > 0) {
            Long unprocessed;
            while ((unprocessed = this.valueQueue.poll()) != null) {
                this.size.decrementAndGet();
                this.accumulatedValue += unprocessed.longValue();
                ++this.accumulatedCount;
                if (++n >= cap) break;
            }
        }
    }

    public double getAverage() {
        this.lock.lock();
        try {
            this.sweep();
            double average = (double)this.accumulatedValue / (double)this.accumulatedCount;
            this.accumulatedValue = 0L;
            this.accumulatedCount = 0;
            double d = average;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }
}

