/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.aggregate;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAccumulator;
import org.smallmind.claxon.registry.aggregate.Aggregate;

public class Bounded
implements Aggregate {
    private final LongAccumulator flipMaxAccumulator = new LongAccumulator(Long::max, Long.MIN_VALUE);
    private final LongAccumulator flipMinAccumulator = new LongAccumulator(Long::min, Long.MAX_VALUE);
    private final LongAccumulator flopMaxAccumulator = new LongAccumulator(Long::max, Long.MIN_VALUE);
    private final LongAccumulator flopMinAccumulator = new LongAccumulator(Long::min, Long.MAX_VALUE);
    private final AtomicBoolean maxFlag = new AtomicBoolean();
    private final AtomicBoolean minFlag = new AtomicBoolean();

    @Override
    public void update(long value) {
        if (!this.maxFlag.get()) {
            this.flipMaxAccumulator.accumulate(value);
        } else {
            this.flopMaxAccumulator.accumulate(value);
        }
        if (!this.minFlag.get()) {
            this.flipMinAccumulator.accumulate(value);
        } else {
            this.flopMinAccumulator.accumulate(value);
        }
    }

    public synchronized long getMaximum() {
        boolean currentFlag = this.maxFlag.get();
        this.maxFlag.set(!currentFlag);
        return !currentFlag ? this.flipMaxAccumulator.getThenReset() : this.flopMaxAccumulator.getThenReset();
    }

    public long getMinimum() {
        boolean currentFlag = this.minFlag.get();
        this.minFlag.set(!currentFlag);
        return !currentFlag ? this.flipMinAccumulator.getThenReset() : this.flopMinAccumulator.getThenReset();
    }
}

