/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.aggregate;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.claxon.registry.Clock;
import org.smallmind.nutsnbolts.time.StintUtility;

public class ExponentiallyWeightedMovingAverage {
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentLinkedQueue<Long> valueQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger size = new AtomicInteger();
    private final Clock clock;
    private final double nanosecondsInWindow;
    private double average = 0.0;
    private long markTime;

    public ExponentiallyWeightedMovingAverage(Clock clock, long window, TimeUnit windowTimeUnit) {
        this.clock = clock;
        this.nanosecondsInWindow = StintUtility.convertToDouble((long)window, (TimeUnit)windowTimeUnit, (TimeUnit)TimeUnit.NANOSECONDS);
        this.markTime = clock.monotonicTime();
    }

    public void update(long value) {
        if (this.lock.tryLock()) {
            try {
                this.sweep(value, 1);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.size.incrementAndGet();
            this.valueQueue.add(value);
        }
    }

    private double sweep(long initialValue, int initialCount) {
        long now = this.clock.monotonicTime();
        long accumulated = initialValue;
        int cap = this.size.get();
        int n = initialCount;
        if (cap > 0) {
            Long unprocessed;
            while ((unprocessed = this.valueQueue.poll()) != null) {
                this.size.decrementAndGet();
                accumulated += unprocessed.longValue();
                if (++n >= cap) break;
            }
        }
        this.average = this.markTime == 0L ? (double)accumulated / (double)n : (this.average += (1.0 - Math.exp(-((double)(now - this.markTime) / this.nanosecondsInWindow))) * ((double)accumulated / (double)n - this.average));
        this.markTime = now;
        return this.average;
    }

    public double getMovingAverage() {
        this.lock.lock();
        try {
            double d = this.sweep(0L, 0);
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }
}

