/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.aggregate;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.aggregate.Aggregate;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.nutsnbolts.time.StintUtility;

public class Paced
implements Aggregate {
    private final Clock clock;
    private final LongAdder adder = new LongAdder();
    private final double nanosecondsInWindow;
    private long markTime;

    public Paced(Clock clock) {
        this(clock, new Stint(1L, TimeUnit.SECONDS));
    }

    public Paced(Clock clock, Stint windowStint) {
        this.clock = clock;
        this.nanosecondsInWindow = StintUtility.convertToDouble((long)windowStint.getTime(), (TimeUnit)windowStint.getTimeUnit(), (TimeUnit)TimeUnit.NANOSECONDS);
        this.markTime = clock.monotonicTime();
    }

    public void inc() {
        this.add(1L);
    }

    public void add(long delta) {
        if (delta < 0L) {
            throw new IllegalArgumentException(String.valueOf(delta) + " is less than 0");
        }
        this.adder.add(delta);
    }

    @Override
    public void update(long value) {
        this.add(value);
    }

    public synchronized double[] getMeasurements() {
        long now = this.clock.monotonicTime();
        long count = this.adder.sum();
        double timeFactor = this.nanosecondsInWindow / (double)(now - this.markTime);
        double rate = (double)count * timeFactor;
        this.adder.add(-count);
        this.markTime = now;
        return new double[]{count, rate};
    }
}

