/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.aggregate;

import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Recorder;
import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.aggregate.Aggregate;
import org.smallmind.claxon.registry.aggregate.HistogramTime;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.nutsnbolts.time.StintUtility;

public class Stratified
implements Aggregate {
    private final Clock clock;
    private final double nanosecondsInWindow;
    private volatile Recorder writeRecorder;
    private Recorder readRecorder;
    private long markTime;

    public Stratified(Clock clock) {
        this(clock, 1L, 3600000L, 2, new Stint(1L, TimeUnit.SECONDS));
    }

    public Stratified(Clock clock, Stint windowStint) {
        this(clock, 1L, 3600000L, 2, windowStint);
    }

    public Stratified(Clock clock, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(clock, lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, new Stint(1L, TimeUnit.SECONDS));
    }

    public Stratified(Clock clock, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits, Stint windowStint) {
        this.clock = clock;
        this.nanosecondsInWindow = StintUtility.convertToDouble((long)windowStint.getTime(), (TimeUnit)windowStint.getTimeUnit(), (TimeUnit)TimeUnit.NANOSECONDS);
        this.writeRecorder = new Recorder(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.readRecorder = new Recorder(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.markTime = clock.monotonicTime();
    }

    @Override
    public void update(long value) {
        this.writeRecorder.recordValue(value);
    }

    public synchronized HistogramTime get() {
        Recorder recorder = this.readRecorder;
        this.readRecorder = this.writeRecorder;
        recorder.reset();
        long now = this.clock.monotonicTime();
        this.writeRecorder = recorder;
        double timeFactor = (double)(now - this.markTime) / this.nanosecondsInWindow;
        this.markTime = now;
        return new HistogramTime(this.readRecorder.getIntervalHistogram(), timeFactor);
    }
}

