/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.json;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.claxon.registry.Percentile;
import org.smallmind.claxon.registry.PercentileInView;
import org.smallmind.claxon.registry.json.HistogramProperties;
import org.smallmind.claxon.registry.json.StintXmlAdapter;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.web.json.scaffold.property.ArrayMutator;

@XmlRootElement(name="histogramProperties", namespace="http://org.smallmind/claxon/registry")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class HistogramPropertiesInView {
    private Stint resolutionStint;
    private PercentileInView[] percentiles;
    private Integer numberOfSignificantValueDigits;
    private Long lowestDiscernibleValue;
    private Long highestTrackableValue;

    public static HistogramPropertiesInView instance(HistogramProperties histogramProperties) {
        return new HistogramPropertiesInView(histogramProperties);
    }

    public HistogramPropertiesInView() {
    }

    public HistogramPropertiesInView(HistogramProperties histogramProperties) {
        this.resolutionStint = histogramProperties.getResolutionStint();
        this.percentiles = (PercentileInView[])ArrayMutator.toViewType(Percentile.class, PercentileInView.class, (Object[])histogramProperties.getPercentiles());
        this.numberOfSignificantValueDigits = histogramProperties.getNumberOfSignificantValueDigits();
        this.lowestDiscernibleValue = histogramProperties.getLowestDiscernibleValue();
        this.highestTrackableValue = histogramProperties.getHighestTrackableValue();
    }

    public HistogramProperties factory() {
        return this.factory(new HistogramProperties());
    }

    public HistogramProperties factory(HistogramProperties histogramProperties) {
        histogramProperties.setResolutionStint(this.resolutionStint);
        histogramProperties.setPercentiles((Percentile[])ArrayMutator.toEntityType(Percentile.class, (Object[])this.percentiles));
        histogramProperties.setNumberOfSignificantValueDigits(this.numberOfSignificantValueDigits);
        histogramProperties.setLowestDiscernibleValue(this.lowestDiscernibleValue);
        histogramProperties.setHighestTrackableValue(this.highestTrackableValue);
        return histogramProperties;
    }

    @XmlJavaTypeAdapter(value=StintXmlAdapter.class)
    @XmlElement(name="resolutionStint")
    public Stint getResolutionStint() {
        return this.resolutionStint;
    }

    public HistogramPropertiesInView setResolutionStint(Stint resolutionStint) {
        this.resolutionStint = resolutionStint;
        return this;
    }

    @XmlElement(name="percentiles")
    public PercentileInView[] getPercentiles() {
        return this.percentiles;
    }

    public HistogramPropertiesInView setPercentiles(PercentileInView[] percentiles) {
        this.percentiles = percentiles;
        return this;
    }

    @XmlElement(name="numberOfSignificantValueDigits")
    public Integer getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public HistogramPropertiesInView setNumberOfSignificantValueDigits(Integer numberOfSignificantValueDigits) {
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return this;
    }

    @XmlElement(name="lowestDiscernibleValue")
    public Long getLowestDiscernibleValue() {
        return this.lowestDiscernibleValue;
    }

    public HistogramPropertiesInView setLowestDiscernibleValue(Long lowestDiscernibleValue) {
        this.lowestDiscernibleValue = lowestDiscernibleValue;
        return this;
    }

    @XmlElement(name="highestTrackableValue")
    public Long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public HistogramPropertiesInView setHighestTrackableValue(Long highestTrackableValue) {
        this.highestTrackableValue = highestTrackableValue;
        return this;
    }
}

