/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.meter;

import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.aggregate.Averaged;
import org.smallmind.claxon.registry.aggregate.Bounded;
import org.smallmind.claxon.registry.meter.Meter;

public class Gauge
implements Meter {
    private final Bounded bounded = new Bounded();
    private final Averaged averaged = new Averaged();

    @Override
    public void update(long value) {
        this.bounded.update(value);
        this.averaged.update(value);
    }

    @Override
    public Quantity[] record() {
        long minimum = this.bounded.getMinimum();
        long maximum = this.bounded.getMaximum();
        double average = this.averaged.getAverage();
        int size = 1;
        int index = 0;
        if (minimum < Long.MAX_VALUE) {
            ++size;
        }
        if (maximum > Long.MIN_VALUE) {
            ++size;
        }
        Quantity[] quantities = new Quantity[size];
        if (minimum < Long.MAX_VALUE) {
            quantities[index++] = new Quantity("minimum", minimum);
        }
        if (maximum > Long.MIN_VALUE) {
            quantities[index++] = new Quantity("maximum", maximum);
        }
        quantities[index] = new Quantity("average", average);
        return quantities;
    }
}

