/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.meter;

import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.Percentile;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.QuantityType;
import org.smallmind.claxon.registry.aggregate.HistogramTime;
import org.smallmind.claxon.registry.aggregate.Stratified;
import org.smallmind.claxon.registry.meter.Meter;
import org.smallmind.nutsnbolts.time.Stint;

public class Histogram
implements Meter {
    private final Stratified stratified;
    private final Percentile[] percentiles;

    public Histogram(Clock clock, long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits, Stint resolutionStint, Percentile ... percentiles) {
        this.percentiles = percentiles;
        this.stratified = new Stratified(clock, lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, resolutionStint);
    }

    @Override
    public void update(long value) {
        this.stratified.update(value);
    }

    @Override
    public Quantity[] record() {
        HistogramTime snapshot = this.stratified.get();
        Quantity[] basicQuantities = new Quantity[]{new Quantity("count", snapshot.getHistogram().getTotalCount(), QuantityType.COUNT), new Quantity("rate", (double)snapshot.getHistogram().getTotalCount() * snapshot.getTimeFactor()), new Quantity("minimum", snapshot.getHistogram().getMinValue()), new Quantity("maximum", snapshot.getHistogram().getMaxValue()), new Quantity("mean", snapshot.getHistogram().getMean())};
        Quantity[] allQuantities = new Quantity[basicQuantities.length + (this.percentiles == null ? 0 : this.percentiles.length)];
        int index = 0;
        System.arraycopy(basicQuantities, 0, allQuantities, 0, basicQuantities.length);
        if (this.percentiles != null && this.percentiles.length > 0) {
            Percentile[] percentileArray = this.percentiles;
            int n = this.percentiles.length;
            int n2 = 0;
            while (n2 < n) {
                Percentile percentile = percentileArray[n2];
                allQuantities[basicQuantities.length + index++] = new Quantity(percentile.getName(), snapshot.getHistogram().getValueAtPercentile(percentile.getValue()));
                ++n2;
            }
        }
        return allQuantities;
    }
}

