/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.meter;

import java.util.concurrent.TimeUnit;
import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.Percentile;
import org.smallmind.claxon.registry.meter.Histogram;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.nutsnbolts.time.Stint;

public class HistogramBuilder
implements MeterBuilder<Histogram> {
    private static final Stint ONE_SECOND_STINT = new Stint(1L, TimeUnit.SECONDS);
    private static final Percentile[] DEFAULT_PERCENTILES = new Percentile[]{new Percentile("p75", 75.0), new Percentile("p95", 95.0), new Percentile("p98", 98.0), new Percentile("p99", 99.0), new Percentile("p999", 99.9)};
    private Stint resolutionStint = ONE_SECOND_STINT;
    private Percentile[] percentiles = DEFAULT_PERCENTILES;
    private long lowestDiscernibleValue = 1L;
    private long highestTrackableValue = 3600000L;
    private int numberOfSignificantValueDigits = 2;

    public HistogramBuilder() {
        System.out.println("hello");
    }

    public MeterBuilder<Histogram> lowestDiscernibleValue(long lowestDiscernibleValue) {
        this.lowestDiscernibleValue = lowestDiscernibleValue;
        return this;
    }

    public MeterBuilder<Histogram> highestTrackableValue(long highestTrackableValue) {
        this.highestTrackableValue = highestTrackableValue;
        return this;
    }

    public MeterBuilder<Histogram> numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return this;
    }

    public MeterBuilder<Histogram> percentiles(Percentile ... percentiles) {
        this.percentiles = percentiles;
        return this;
    }

    public MeterBuilder<Histogram> resolution(Stint resolutionStint) {
        this.resolutionStint = resolutionStint;
        return this;
    }

    @Override
    public Histogram build(Clock clock) {
        return new Histogram(clock, this.lowestDiscernibleValue, this.highestTrackableValue, this.numberOfSignificantValueDigits, this.resolutionStint, this.percentiles);
    }
}

