/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.meter;

import org.smallmind.claxon.registry.Clock;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.QuantityType;
import org.smallmind.claxon.registry.aggregate.Bounded;
import org.smallmind.claxon.registry.aggregate.Paced;
import org.smallmind.claxon.registry.meter.Meter;
import org.smallmind.nutsnbolts.time.Stint;

public class Speedometer
implements Meter {
    private final Bounded bounded = new Bounded();
    private final Paced paced;

    public Speedometer(Clock clock, Stint windowStint) {
        this.paced = new Paced(clock, windowStint);
    }

    @Override
    public void update(long value) {
        this.bounded.update(value);
        this.paced.update(1L);
    }

    @Override
    public Quantity[] record() {
        double[] measurements = this.paced.getMeasurements();
        long minimum = this.bounded.getMinimum();
        long maximum = this.bounded.getMaximum();
        int size = 2;
        int index = 0;
        if (minimum < Long.MAX_VALUE) {
            ++size;
        }
        if (maximum > Long.MIN_VALUE) {
            ++size;
        }
        Quantity[] quantities = new Quantity[size];
        if (minimum < Long.MAX_VALUE) {
            quantities[index++] = new Quantity("minimum", minimum);
        }
        if (maximum > Long.MIN_VALUE) {
            quantities[index++] = new Quantity("maximum", maximum);
        }
        quantities[index++] = new Quantity("count", measurements[0], QuantityType.COUNT);
        quantities[index] = new Quantity("rate", measurements[1]);
        return quantities;
    }
}

