/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.registry.spring;

import java.util.HashMap;
import java.util.Map;
import org.smallmind.claxon.registry.ClaxonConfiguration;
import org.smallmind.claxon.registry.ClaxonRegistry;
import org.smallmind.claxon.registry.Emitter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ClaxonRegistryFactoryBean
implements FactoryBean<ClaxonRegistry>,
InitializingBean,
DisposableBean {
    private ClaxonRegistry registry;
    private ClaxonConfiguration configuration = new ClaxonConfiguration();
    private Map<String, Emitter> emitterMap = new HashMap<String, Emitter>();

    public void setConfiguration(ClaxonConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setEmitterMap(Map<String, Emitter> emitterMap) {
        this.emitterMap = emitterMap;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return ClaxonRegistry.class;
    }

    public ClaxonRegistry getObject() {
        return this.registry;
    }

    public void destroy() throws InterruptedException {
        if (this.registry != null) {
            this.registry.stop();
        }
    }

    public void afterPropertiesSet() {
        this.registry = new ClaxonRegistry(this.configuration);
        for (Map.Entry<String, Emitter> emitterEntry : this.emitterMap.entrySet()) {
            this.registry.bind(emitterEntry.getKey(), emitterEntry.getValue());
        }
        this.registry.initializeInstrumentation();
    }
}

