/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.bayeux.oumuamua.server.api;

import java.util.Set;
import org.smallmind.bayeux.oumuamua.server.api.Attributed;
import org.smallmind.bayeux.oumuamua.server.api.Packet;
import org.smallmind.bayeux.oumuamua.server.api.Route;
import org.smallmind.bayeux.oumuamua.server.api.Session;
import org.smallmind.bayeux.oumuamua.server.api.json.ObjectValue;
import org.smallmind.bayeux.oumuamua.server.api.json.Value;

public interface Channel<V extends Value<V>>
extends Attributed {
    public static final String WILD = "*";
    public static final String DEEP_WILD = "**";

    public void addListener(Listener<V> var1);

    public void removeListener(Listener<V> var1);

    public Route getRoute();

    default public boolean isWild() {
        return this.getRoute().isWild();
    }

    default public boolean isDeepWild() {
        return this.getRoute().isDeepWild();
    }

    default public boolean isMeta() {
        return this.getRoute().isMeta();
    }

    default public boolean isService() {
        return this.getRoute().isService();
    }

    default public boolean isDeliverable() {
        return this.getRoute().isDeliverable();
    }

    public boolean isPersistent();

    public void setPersistent(boolean var1);

    public boolean isReflecting();

    public void setReflecting(boolean var1);

    public boolean subscribe(Session<V> var1);

    public void unsubscribe(Session<V> var1);

    public boolean isRemovable(long var1);

    public void deliver(Session<V> var1, Packet<V> var2, Set<String> var3);

    public void publish(ObjectValue<V> var1);

    public static interface PacketListener<V extends Value<V>>
    extends Listener<V> {
        @Override
        public boolean isPersistent();

        public Packet<V> onDelivery(Session<V> var1, Packet<V> var2);
    }

    public static interface SessionListener<V extends Value<V>>
    extends Listener<V> {
        public void onSubscribed(Session<V> var1);

        public void onUnsubscribed(Session<V> var1);
    }

    public static interface Listener<V extends Value<V>> {
        public boolean isPersistent();
    }
}

