/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.bayeux.oumuamua.server.api;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.smallmind.bayeux.oumuamua.server.api.Attributed;
import org.smallmind.bayeux.oumuamua.server.api.Channel;
import org.smallmind.bayeux.oumuamua.server.api.ChannelInitializer;
import org.smallmind.bayeux.oumuamua.server.api.ChannelStateException;
import org.smallmind.bayeux.oumuamua.server.api.InvalidPathException;
import org.smallmind.bayeux.oumuamua.server.api.Packet;
import org.smallmind.bayeux.oumuamua.server.api.Protocol;
import org.smallmind.bayeux.oumuamua.server.api.SecurityPolicy;
import org.smallmind.bayeux.oumuamua.server.api.Session;
import org.smallmind.bayeux.oumuamua.server.api.backbone.Backbone;
import org.smallmind.bayeux.oumuamua.server.api.json.Codec;
import org.smallmind.bayeux.oumuamua.server.api.json.Value;

public interface Server<V extends Value<V>>
extends Attributed {
    public static final String ATTRIBUTE = "org.smallmind.bayeux.oumuamua.server";

    public void addListener(Listener<V> var1);

    public void removeListener(Listener<V> var1);

    public void start(ServletConfig var1) throws ServletException;

    public void stop();

    public String getBayeuxVersion();

    public String getMinimumBayeuxVersion();

    public long getSessionConnectionIntervalMilliseconds();

    public String[] getProtocolNames();

    public Protocol<V> getProtocol(String var1);

    public Backbone<V> getBackbone();

    public SecurityPolicy<V> getSecurityPolicy();

    public Codec<V> getCodec();

    public Session<V> getSession(String var1);

    public void addInitializer(ChannelInitializer<V> var1);

    public void removeInitializer(ChannelInitializer<V> var1);

    public Channel<V> findChannel(String var1) throws InvalidPathException;

    public Channel<V> requireChannel(String var1, ChannelInitializer ... var2) throws InvalidPathException;

    public void removeChannel(Channel<V> var1) throws ChannelStateException;

    public Packet<V> onRequest(Session<V> var1, Packet<V> var2);

    public Packet<V> onResponse(Session<V> var1, Packet<V> var2);

    public void deliver(Session<V> var1, Packet<V> var2, boolean var3);

    public void forward(Channel<V> var1, Packet<V> var2);

    public static interface PacketListener<V extends Value<V>>
    extends Listener<V> {
        public Packet<V> onRequest(Session<V> var1, Packet<V> var2);

        public Packet<V> onResponse(Session<V> var1, Packet<V> var2);

        public Packet<V> onDelivery(Session<V> var1, Packet<V> var2);
    }

    public static interface SubscriptionListener<V extends Value<V>>
    extends Listener<V> {
        public void onSubscribed(Channel<V> var1, Session<V> var2);

        public void onUnsubscribed(Channel<V> var1, Session<V> var2);
    }

    public static interface ChannelListener<V extends Value<V>>
    extends Listener<V> {
        public void onCreated(Channel<V> var1);

        public void onRemoved(Channel<V> var1);
    }

    public static interface SessionListener<V extends Value<V>>
    extends Listener<V> {
        public void onConnected(Session<V> var1);

        public void onDisconnected(Session<V> var1);
    }

    public static interface Listener<V extends Value<V>> {
    }
}

