/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.bayeux.oumuamua.server.api.json;

import java.util.Iterator;
import org.smallmind.bayeux.oumuamua.server.api.json.Value;
import org.smallmind.bayeux.oumuamua.server.api.json.ValueType;

public interface ObjectValue<V extends Value<V>>
extends Value<V> {
    @Override
    default public ValueType getType() {
        return ValueType.OBJECT;
    }

    default public ObjectValue<V> put(String field, boolean bool) {
        return this.put(field, this.getFactory().booleanValue(bool));
    }

    default public ObjectValue<V> put(String field, int i) {
        return this.put(field, this.getFactory().numberValue(i));
    }

    default public ObjectValue<V> put(String field, long l) {
        return this.put(field, this.getFactory().numberValue(l));
    }

    default public ObjectValue<V> put(String field, double d) {
        return this.put(field, this.getFactory().numberValue(d));
    }

    default public ObjectValue<V> put(String field, String text) {
        return this.put(field, text == null ? this.getFactory().nullValue() : this.getFactory().textValue(text));
    }

    public int size();

    public boolean isEmpty();

    public Iterator<String> fieldNames();

    public Value<V> get(String var1);

    public <U extends Value<V>> ObjectValue<V> put(String var1, U var2);

    public Value<V> remove(String var1);

    public ObjectValue<V> removeAll();
}

